/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.backend.kiwi;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.api.triplestore.SesameService;
import org.apache.marmotta.platform.core.jaxrs.exceptionmappers.ErrorResponse;
import org.slf4j.Logger;

@Path(value="/storage-kiwi")
@ApplicationScoped
public class DatabaseWebService {
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private SesameService sesameService;

    @POST
    @Path(value="/ping")
    public Response pingDatabase(@QueryParam(value="type") String type, @QueryParam(value="url") String url, @QueryParam(value="user") String user, @QueryParam(value="pwd") String pwd) {
        if (type == null || url == null || user == null || pwd == null) {
            return Response.status((int)400).entity((Object)"one or more values are not defined").build();
        }
        String db_driver = this.configurationService.getStringConfiguration("database." + type + ".driver");
        if (db_driver == null) {
            return ErrorResponse.errorResponse((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)("driver for " + type + " not defined"));
        }
        if (!url.startsWith("jdbc:" + type)) {
            return ErrorResponse.errorResponse((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)"database and url do not match properly");
        }
        try {
            Class.forName(db_driver);
            Connection conn = DriverManager.getConnection(url, user, pwd);
            conn.close();
            return Response.ok().build();
        }
        catch (ClassNotFoundException e) {
            return ErrorResponse.errorResponse((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)"Can't load driver ", (Exception)e);
        }
        catch (SQLException e) {
            return ErrorResponse.errorResponse((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (String)"Database access failed ", (Exception)e);
        }
    }

    @POST
    @Path(value="/gc")
    public Response garbageCollector() {
        this.log.info("Running triple store garbage collection after admin user request ...");
        try {
            this.sesameService.garbageCollect();
            return Response.ok().entity((Object)"garbage collection completed successfully").build();
        }
        catch (Exception ex) {
            this.log.error("Error while running garbage collection ...", (Throwable)ex);
            return ErrorResponse.errorResponse((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Exception)ex);
        }
    }
}

