/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.model.transformers.StringTransformer;
import org.apache.marmotta.ldpath.util.Collections;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanHtmlFunction<Node>
extends SelectorFunction<Node> {
    private final StringTransformer<Node> transformer = new StringTransformer();
    private Logger log = LoggerFactory.getLogger(CleanHtmlFunction.class);

    public Collection<Node> apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        Iterator<Node> it;
        if (args.length < 1) {
            this.log.debug("clean HTML from context {}", context);
            it = java.util.Collections.singleton(context).iterator();
        } else {
            this.log.debug("clean HTML from parameters");
            it = Collections.iterator((Collection[])args);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        while (it.hasNext()) {
            Node node = it.next();
            String cleaned = Jsoup.clean((String)this.transformer.transform((RDFBackend)backend, (Object)node, (Map)null), (Whitelist)Whitelist.basic());
            result.add(backend.createLiteral(cleaned));
        }
        return result;
    }

    public String getLocalName() {
        return "cleanHtml";
    }

    public String getSignature() {
        return "fn:cleanHtml(content: LiteralList) : LiteralList";
    }

    public String getDescription() {
        return "Function to clean up HTML and remove all script and style elements from the content. Can be used in-path, using the current context nodes as argument.";
    }
}

