/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.coll;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.model.functions.coll.AbstractCollFunction;

public class SubListFunction<Node>
extends AbstractCollFunction<Node> {
    public Collection<Node> apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        int end;
        int start;
        Collection<Node> nodes;
        switch (args.length) {
            case 1: {
                nodes = Collections.singleton(context);
                start = this.getIndex(backend, args[0]);
                end = Integer.MAX_VALUE;
                break;
            }
            case 2: {
                if (args[0].size() == 1 && backend.isLiteral(args[0].iterator().next())) {
                    nodes = Collections.singleton(context);
                    start = this.getIndex(backend, args[0]);
                    end = this.getIndex(backend, args[1]);
                    break;
                }
                nodes = args[0];
                start = this.getIndex(backend, args[1]);
                end = Integer.MAX_VALUE;
                break;
            }
            case 3: {
                nodes = args[0];
                start = this.getIndex(backend, args[1]);
                end = this.getIndex(backend, args[2]);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.getLocalName() + " takes at most 3 arguments");
            }
        }
        LinkedList<Node> result = new LinkedList<Node>();
        for (Node node : nodes) {
            if (this.hasType(backend, node, "http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag")) {
                result.addAll(this.subListFromContainer(backend, node, start, end));
                continue;
            }
            if (this.hasType(backend, node, "http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq")) {
                result.addAll(this.subListFromContainer(backend, node, start, end));
                continue;
            }
            if (this.hasType(backend, node, "http://www.w3.org/1999/02/22-rdf-syntax-ns#List")) {
                this.subListFromCollection(backend, node, start, end, result);
                continue;
            }
            this.subListFromCollection(backend, node, start, end, result);
        }
        return result;
    }

    private void subListFromCollection(RDFBackend<Node> backend, Node node, int start, int end, List<Node> result) {
        if (this.isNil(backend, node)) {
            return;
        }
        if (end > 0) {
            if (start <= 0) {
                result.addAll(backend.listObjects(node, backend.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#first")));
            }
            for (Object n : backend.listObjects(node, backend.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest"))) {
                this.subListFromCollection(backend, n, start - 1, end - 1, result);
            }
        }
    }

    private Collection<? extends Node> subListFromContainer(RDFBackend<Node> backend, Node node, int start, int end) {
        Collection objects;
        LinkedList result = new LinkedList();
        for (int i = start; i < end && (objects = backend.listObjects(node, backend.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + (i + 1)))).size() > 0; ++i) {
            result.addAll(objects);
        }
        return result;
    }

    public String getSignature() {
        return "fn:subList([nodes: NodeList,] start: Integer [, end: Integer]) :: NodeList";
    }

    public String getDescription() {
        return "select a range from a rdf-Collection (like substring does for strings, 0-based)";
    }

    protected String getLocalName() {
        return "subList";
    }
}

