/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.coll;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.model.functions.coll.AbstractCollFunction;

public class GetFunction<Node>
extends AbstractCollFunction<Node> {
    public Collection<Node> apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        int index;
        Collection<Node> nodes;
        switch (args.length) {
            case 1: {
                nodes = Collections.singleton(context);
                index = this.getIndex(backend, args[0]);
                break;
            }
            case 2: {
                nodes = args[0];
                index = this.getIndex(backend, args[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.getLocalName() + " must not have more than one or two parameters");
            }
        }
        HashSet<Node> result = new HashSet<Node>();
        for (Node node : nodes) {
            if (this.hasType(backend, node, "http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag")) {
                result.addAll(this.getFromContainer(backend, node, index));
                continue;
            }
            if (this.hasType(backend, node, "http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq")) {
                result.addAll(this.getFromContainer(backend, node, index));
                continue;
            }
            if (this.hasType(backend, node, "http://www.w3.org/1999/02/22-rdf-syntax-ns#List")) {
                result.addAll(this.getFromCollection(backend, node, index));
                continue;
            }
            result.addAll(this.getFromCollection(backend, node, index));
        }
        return result;
    }

    private Collection<Node> getFromCollection(RDFBackend<Node> backend, Node node, int index) {
        if (index < 0 || this.isNil(backend, node)) {
            return Collections.emptySet();
        }
        if (index == 0) {
            return backend.listObjects(node, backend.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#first"));
        }
        HashSet<Node> result = new HashSet<Node>();
        for (Object n : backend.listObjects(node, backend.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest"))) {
            result.addAll(this.getFromCollection(backend, n, index - 1));
        }
        return result;
    }

    private Collection<Node> getFromContainer(RDFBackend<Node> backend, Node node, int index) {
        return backend.listObjects(node, backend.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + (index + 1)));
    }

    public String getSignature() {
        return "fn:get([nodes: NodeList,] n: Integer) :: NodeList";
    }

    public String getDescription() {
        return "retrieve the nth element from a rdf-Collection (0-based)";
    }

    protected String getLocalName() {
        return "get";
    }
}

