/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.coll;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.model.functions.coll.AbstractCollFunction;

public class FlattenFunction<Node>
extends AbstractCollFunction<Node> {
    public Collection<Node> apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        if (args.length > 1) {
            throw new IllegalArgumentException(this.getLocalName() + " must not have more than one parameter");
        }
        Collection<Node> nodes = args.length > 0 ? args[0] : Collections.singleton(context);
        LinkedList result = new LinkedList();
        for (Node node : nodes) {
            if (this.hasType(backend, node, "http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag")) {
                this.flattenContainer(backend, node, result);
                continue;
            }
            if (this.hasType(backend, node, "http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq")) {
                this.flattenContainer(backend, node, result);
                continue;
            }
            if (this.hasType(backend, node, "http://www.w3.org/1999/02/22-rdf-syntax-ns#List")) {
                this.flattenCollection(backend, node, result, new HashSet());
                continue;
            }
            this.flattenCollection(backend, node, result, new HashSet());
        }
        return result;
    }

    private void flattenCollection(RDFBackend<Node> backend, Node node, Collection<Node> result, Collection<Node> backtrace) {
        if (this.isNil(backend, node)) {
            return;
        }
        if (!backtrace.add(node)) {
            return;
        }
        result.addAll(backend.listObjects(node, backend.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#first")));
        Collection rest = backend.listObjects(node, backend.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest"));
        for (Object r : rest) {
            this.flattenCollection(backend, r, result, backtrace);
        }
    }

    private void flattenContainer(RDFBackend<Node> backend, Node node, Collection<Node> result) {
        Collection objects;
        int i = 1;
        while ((objects = backend.listObjects(node, backend.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + i))).size() > 0) {
            result.addAll(objects);
            ++i;
        }
    }

    public String getSignature() {
        return "fn:flatten([nodes: NodeList]) :: NodeList";
    }

    public String getDescription() {
        return "Flattens a rdf-Collection";
    }

    protected String getLocalName() {
        return "flatten";
    }
}

