/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.coll;

import java.util.Collection;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;

public abstract class AbstractCollFunction<Node>
extends SelectorFunction<Node> {
    protected static final String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";

    protected int getIndex(RDFBackend<Node> backend, Collection<Node> collection) {
        if (collection.size() != 1) {
            throw new IllegalArgumentException("index must be a singel integer literal");
        }
        return backend.intValue(collection.iterator().next());
    }

    protected boolean hasType(RDFBackend<Node> backend, Node node, String type) {
        return backend.listObjects(node, backend.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")).contains(backend.createURI(type));
    }

    protected boolean isNil(RDFBackend<Node> backend, Node node) {
        return backend.isURI(node) && backend.stringValue(node).equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
    }
}

