/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.selectors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.selectors.NodeSelector;

public class StringConstantSelector<Node>
implements NodeSelector<Node> {
    private String constant;

    public StringConstantSelector(String constant) {
        this.constant = constant;
    }

    public Collection<Node> select(RDFBackend<Node> rdfBackend, Node context, List<Node> path, Map<Node, List<Node>> resultPaths) {
        return Collections.singleton(rdfBackend.createLiteral(this.constant));
    }

    public String getPathExpression(NodeBackend<Node> rdfBackend) {
        return String.format("\"%s\"", this.constant);
    }

    public String getName(NodeBackend<Node> nodeRDFBackend) {
        return this.constant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringConstantSelector that = (StringConstantSelector)o;
        return !(this.constant != null ? !this.constant.equals(that.constant) : that.constant != null);
    }

    public int hashCode() {
        return this.constant != null ? this.constant.hashCode() : 0;
    }
}

