/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.selectors;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.selectors.NodeSelector;

public class GroupedSelector<Node>
implements NodeSelector<Node> {
    private final NodeSelector<Node> content;

    public GroupedSelector(NodeSelector<Node> content) {
        this.content = content;
    }

    public Collection<Node> select(RDFBackend<Node> rdfBackend, Node context, List<Node> path, Map<Node, List<Node>> resultPaths) {
        return this.content.select(rdfBackend, context, path, resultPaths);
    }

    public String getPathExpression(NodeBackend<Node> rdfBackend) {
        return String.format("(%s)", this.content.getPathExpression(rdfBackend));
    }

    public String getName(NodeBackend<Node> nodeRDFBackend) {
        throw new UnsupportedOperationException("cannot use a group in unnamed field definitions because the name is ambiguous");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupedSelector that = (GroupedSelector)o;
        return !(this.content != null ? !this.content.equals(that.content) : that.content != null);
    }

    public int hashCode() {
        int result = 31;
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        return result;
    }
}

