/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.model.transformers.StringTransformer;
import org.apache.marmotta.ldpath.util.Collections;

public class ConcatenateFunction<Node>
extends SelectorFunction<Node> {
    private final StringTransformer<Node> transformer = new StringTransformer();

    @SafeVarargs
    public final Collection<Node> apply(RDFBackend<Node> rdfBackend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        Iterator<Node> it = Collections.iterator(args);
        StringBuilder result = new StringBuilder();
        while (it.hasNext()) {
            result.append((String)this.transformer.transform((RDFBackend)rdfBackend, (Object)it.next(), (Map)null));
        }
        return java.util.Collections.singleton(rdfBackend.createLiteral(result.toString()));
    }

    public String getLocalName() {
        return "concat";
    }

    public String getSignature() {
        return "fn:concat(nodes : NodeList) : String";
    }

    public String getDescription() {
        return "A node function concatenating a list of nodes interpreted as strings.";
    }
}

