/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.phpbb;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.provider.html.AbstractHTMLDataProvider;
import org.apache.marmotta.ldclient.provider.html.mapping.CssSelectorMapper;
import org.apache.marmotta.ldclient.provider.html.mapping.CssTextLiteralMapper;
import org.apache.marmotta.ldclient.provider.html.mapping.JSoupMapper;
import org.apache.marmotta.ldclient.provider.phpbb.mapping.PHPBBDateMapper;
import org.apache.marmotta.ldclient.provider.phpbb.mapping.PHPBBForumHrefMapper;
import org.apache.marmotta.ldclient.provider.phpbb.mapping.PHPBBPostIdMapper;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class PHPBBTopicProvider
extends AbstractHTMLDataProvider {
    public static final String PROVIDER_NAME = "PHPBB Forum Topic";

    protected List<String> getTypes(org.openrdf.model.URI resource) {
        return ImmutableList.of((Object)"http://rdfs.org/sioc/ns#Thread", (Object)"http://rdfs.org/sioc/ns#Collection", (Object)"http://xmlns.com/foaf/0.1/Document");
    }

    protected Map<String, JSoupMapper> getMappings(String resource, String requestUrl) {
        URI uri = null;
        try {
            uri = new URI(requestUrl);
            HashMap<String, String> params = new HashMap<String, String>();
            for (NameValuePair p : URLEncodedUtils.parse((URI)uri, (String)"UTF-8")) {
                params.put(p.getName(), p.getValue());
            }
            if (params.containsKey("t")) {
                HashMap<String, JSoupMapper> postMappings = new HashMap<String, JSoupMapper>();
                if (params.containsKey("start")) {
                    postMappings.put("http://rdfs.org/sioc/ns#container_of", (JSoupMapper)new PHPBBPostIdMapper("div#pagecontent table td.gensmall a[name]"));
                } else {
                    postMappings.put("http://purl.org/dc/elements/1.1/title", (JSoupMapper)new CssTextLiteralMapper("div#pageheader a.titles"));
                    postMappings.put("http://purl.org/dc/elements/1.1/creator", (JSoupMapper)new CssTextLiteralMapper(new CssSelectorMapper.Selector(){

                        public Elements select(Element node) {
                            Element first = node.select("div#pagecontent table b.postauthor").first();
                            if (first != null) {
                                return new Elements(new Element[]{first});
                            }
                            return new Elements();
                        }
                    }));
                    postMappings.put("http://purl.org/dc/elements/1.1/date", (JSoupMapper)new PHPBBDateMapper("div#pagecontent table td.gensmall div"){

                        public Elements select(Element htmlDoc) {
                            Element e;
                            Elements sel = super.select(htmlDoc);
                            if (sel.size() > 0 && (e = sel.get(1)) != null) {
                                return new Elements(new Element[]{e});
                            }
                            return new Elements();
                        }
                    });
                    postMappings.put("http://rdfs.org/sioc/ns#has_container", (JSoupMapper)new PHPBBForumHrefMapper("p.breadcrumbs a"){

                        public Elements select(Element htmlDoc) {
                            Element select = super.select(htmlDoc).last();
                            return select != null ? new Elements(new Element[]{select}) : new Elements();
                        }
                    });
                    postMappings.put("http://rdfs.org/sioc/ns#container_of", (JSoupMapper)new PHPBBPostIdMapper("div#pagecontent table td.gensmall a[name]"));
                }
                return postMappings;
            }
            throw new RuntimeException("the requested resource does not seem to identify a PHPBB topic (t=... parameter missing)");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("the requested resource does not seem to identify a PHPBB topic (URI syntax error)");
        }
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    public String[] listMimeTypes() {
        return new String[]{"text/html"};
    }

    public List<String> buildRequestUrl(String resource, Endpoint endpoint) {
        return Collections.singletonList(resource);
    }

    protected List<String> findAdditionalRequestUrls(String resource, Document document, String requestUrl) {
        LinkedList<String> result = new LinkedList<String>();
        Elements values = document.select("div#pagecontent a[href~=viewtopic\\.php.*start=]");
        for (Element o : values) {
            String baseUrl = o.absUrl("href");
            if (baseUrl.length() <= 0) continue;
            result.add(baseUrl);
        }
        return result;
    }
}

