/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.phpbb;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.api.provider.DataProvider;
import org.apache.marmotta.ldclient.provider.html.AbstractHTMLDataProvider;
import org.apache.marmotta.ldclient.provider.html.mapping.CssTextLiteralMapper;
import org.apache.marmotta.ldclient.provider.html.mapping.JSoupMapper;
import org.apache.marmotta.ldclient.provider.phpbb.mapping.PHPBBDateMapper;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class PHPBBPostProvider
extends AbstractHTMLDataProvider
implements DataProvider {
    public static final String PROVIDER_NAME = "PHPBB Forum Post";

    protected List<String> getTypes(org.openrdf.model.URI resource) {
        return ImmutableList.of((Object)"http://rdfs.org/sioc/types#BoardPost", (Object)"http://rdfs.org/sioc/ns#Post", (Object)"http://xmlns.com/foaf/0.1/Document");
    }

    protected Map<String, JSoupMapper> getMappings(String resource, String requestUrl) {
        URI uri = null;
        try {
            uri = new URI(requestUrl);
            HashMap<String, String> params = new HashMap<String, String>();
            for (NameValuePair p : URLEncodedUtils.parse((URI)uri, (String)"UTF-8")) {
                params.put(p.getName(), p.getValue());
            }
            if (params.containsKey("p")) {
                HashMap<String, JSoupMapper> commentMappings = new HashMap<String, JSoupMapper>();
                commentMappings.put("http://purl.org/dc/elements/1.1/title", (JSoupMapper)new CssTextLiteralMapper(String.format("div#pagecontent table:has(a[name=p%s]) td.gensmall div", params.get("p"))){

                    public List<Value> map(String resourceUri, Element elem, ValueFactory factory) {
                        String val = elem.ownText().replaceFirst("^\\s*:", "").replaceAll("&nbsp;", " ").trim();
                        if (this.datatype != null) {
                            return Collections.singletonList(factory.createLiteral(val, factory.createURI("http://www.w3.org/2001/XMLSchema#" + this.datatype)));
                        }
                        return Collections.singletonList(factory.createLiteral(val));
                    }

                    public Elements select(Element htmlDoc) {
                        Element first = super.select(htmlDoc).first();
                        return first != null ? new Elements(new Element[]{first}) : new Elements();
                    }
                });
                commentMappings.put("http://purl.org/dc/elements/1.1/creator", (JSoupMapper)new CssTextLiteralMapper(String.format("div#pagecontent table:has(a[name=p%s]) .postauthor", params.get("p"))));
                commentMappings.put("http://purl.org/dc/elements/1.1/description", (JSoupMapper)new CssTextLiteralMapper(String.format("div#pagecontent table:has(a[name=p%s]) div.postbody", params.get("p"))));
                commentMappings.put("http://purl.org/dc/elements/1.1/date", (JSoupMapper)new PHPBBDateMapper(String.format("div#pagecontent td.gensmall:has(a[name=p%s]) div", params.get("p"))){

                    public Elements select(Element htmlDoc) {
                        Element e;
                        Elements sel = super.select(htmlDoc);
                        if (sel.size() > 0 && (e = sel.get(1)) != null) {
                            return new Elements(new Element[]{e});
                        }
                        return new Elements();
                    }
                });
                return commentMappings;
            }
            throw new RuntimeException("the requested resource does not seem to identify a PHPBB Post (p=... parameter missing)");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("the requested resource does not seem to identify a PHPBB Post (URI syntax error)");
        }
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    public String[] listMimeTypes() {
        return new String[]{"text/html"};
    }

    public List<String> buildRequestUrl(String resource, Endpoint endpoint) {
        return Collections.singletonList(resource);
    }
}

