/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.phpbb;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.api.provider.DataProvider;
import org.apache.marmotta.ldclient.provider.html.AbstractHTMLDataProvider;
import org.apache.marmotta.ldclient.provider.html.mapping.CssTextLiteralMapper;
import org.apache.marmotta.ldclient.provider.html.mapping.JSoupMapper;
import org.apache.marmotta.ldclient.provider.phpbb.mapping.PHPBBForumHrefMapper;
import org.apache.marmotta.ldclient.provider.phpbb.mapping.PHPBBTopicHrefMapper;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class PHPBBForumProvider
extends AbstractHTMLDataProvider
implements DataProvider {
    public static final String PROVIDER_NAME = "PHPBB Forum";

    protected List<String> getTypes(org.openrdf.model.URI resource) {
        return ImmutableList.of((Object)"http://rdfs.org/sioc/ns#Forum", (Object)"http://rdfs.org/sioc/ns#Collection", (Object)"http://xmlns.com/foaf/0.1/Document");
    }

    protected Map<String, JSoupMapper> getMappings(String resource, String requestUrl) {
        URI uri = null;
        try {
            uri = new URI(requestUrl);
            HashMap<String, String> params = new HashMap<String, String>();
            for (NameValuePair p : URLEncodedUtils.parse((URI)uri, (String)"UTF-8")) {
                params.put(p.getName(), p.getValue());
            }
            if (params.containsKey("f")) {
                HashMap<String, JSoupMapper> postMappings = new HashMap<String, JSoupMapper>();
                if (params.containsKey("start")) {
                    postMappings.put("http://rdfs.org/sioc/ns#container_of", (JSoupMapper)new PHPBBTopicHrefMapper("a.topictitle"));
                } else {
                    postMappings.put("http://purl.org/dc/elements/1.1/title", (JSoupMapper)new CssTextLiteralMapper("div#pageheader a.titles"));
                    postMappings.put("http://purl.org/dc/elements/1.1/description", (JSoupMapper)new CssTextLiteralMapper("div#pageheader span.forumdesc"));
                    postMappings.put("http://rdfs.org/sioc/ns#container_of", (JSoupMapper)new PHPBBTopicHrefMapper("a.topictitle"));
                    postMappings.put("http://rdfs.org/sioc/ns#parent_of", (JSoupMapper)new PHPBBForumHrefMapper("a.forumlink, a.forumtitle"));
                }
                return postMappings;
            }
            throw new RuntimeException("the requested resource does not seem to identify a PHPBB Forum (t=... parameter missing)");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("the requested resource does not seem to identify a PHPBB Forum (URI syntax error)");
        }
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    public String[] listMimeTypes() {
        return new String[]{"text/html"};
    }

    public List<String> buildRequestUrl(String resource, Endpoint endpoint) {
        return Collections.singletonList(resource);
    }

    protected List<String> findAdditionalRequestUrls(String resource, Document document, String requestUrl) {
        LinkedList<String> result = new LinkedList<String>();
        String foo = "a[href*='start='][href*='viewforum.php']";
        Elements values = document.select(foo);
        for (Element e : values) {
            String baseUrl = e.absUrl("href");
            if (baseUrl.length() <= 0) continue;
            result.add(baseUrl);
        }
        return result;
    }
}

