/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.phpbb.mapping;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.marmotta.ldclient.provider.html.mapping.CssSelectorMapper;
import org.jsoup.nodes.Element;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class PHPBBTopicHrefMapper
extends CssSelectorMapper {
    public PHPBBTopicHrefMapper(String css) {
        super(css);
    }

    public List<Value> map(String resourceUri, Element selectedValue, ValueFactory factory) {
        String baseUriSite = resourceUri.substring(0, resourceUri.lastIndexOf(47));
        String baseUriTopic = baseUriSite + "/viewtopic.php?";
        try {
            URI uri = new URI(selectedValue.absUrl("href"));
            HashMap<String, String> params = new HashMap<String, String>();
            for (NameValuePair p : URLEncodedUtils.parse((URI)uri, (String)"UTF-8")) {
                params.put(p.getName(), p.getValue());
            }
            return Collections.singletonList(factory.createURI(baseUriTopic + "t=" + (String)params.get("t")));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("invalid syntax for URI", ex);
        }
    }
}

