/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.phpbb.mapping;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.marmotta.commons.util.DateUtils;
import org.apache.marmotta.ldclient.provider.html.mapping.CssTextLiteralMapper;
import org.jsoup.nodes.Element;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class PHPBBDateMapper
extends CssTextLiteralMapper {
    public PHPBBDateMapper(String xpath) {
        super(xpath);
    }

    public List<Value> map(String resourceUri, Element el, ValueFactory factory) {
        String selectedValue = el.text();
        while (!Character.isDigit(selectedValue.charAt(0))) {
            selectedValue = selectedValue.substring(1, selectedValue.length());
        }
        while (!Character.isDigit(selectedValue.charAt(selectedValue.length() - 1))) {
            selectedValue = selectedValue.substring(0, selectedValue.length() - 1);
        }
        Date date = DateUtils.parseDate((String)selectedValue);
        return Collections.singletonList(factory.createLiteral(DateUtils.ISO8601FORMAT.format(date), factory.createURI("http://www.w3.org/2001/XMLSchema#dateTime")));
    }
}

