/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.test.helper;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.http.client.HttpClient;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.api.ldclient.LDClientService;
import org.apache.marmotta.ldclient.api.provider.DataProvider;
import org.apache.marmotta.ldclient.exception.DataRetrievalException;
import org.apache.marmotta.ldclient.model.ClientConfiguration;
import org.apache.marmotta.ldclient.model.ClientResponse;
import org.junit.Assume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLDClient
implements LDClientService {
    private static final Logger log = LoggerFactory.getLogger(TestLDClient.class);
    public static final List<Check> DEFAULT_CHECKS;
    private final LDClientService delegate;
    private final List<Check> extraCheck;
    private boolean defaultChecks = true;

    public TestLDClient(LDClientService delegate) {
        this(delegate, new LinkedList<Check>());
    }

    public TestLDClient(LDClientService delegate, LinkedList<Check> extraChecks) {
        this(delegate, extraChecks, true);
    }

    public TestLDClient(LDClientService delegate, LinkedList<Check> extraChecks, boolean defaultChecks) {
        this.delegate = delegate;
        this.extraCheck = extraChecks;
        this.defaultChecks = defaultChecks;
    }

    public boolean ping(String resource) {
        return this.delegate.ping(resource);
    }

    public ClientResponse retrieveResource(String resource) throws DataRetrievalException {
        try {
            return this.delegate.retrieveResource(resource);
        }
        catch (DataRetrievalException e) {
            if (this.defaultChecks) {
                for (Check exCheck : DEFAULT_CHECKS) {
                    exCheck.matches(e);
                }
            }
            for (Check exCheck : this.extraCheck) {
                exCheck.matches(e);
            }
            throw e;
        }
    }

    public HttpClient getClient() {
        return this.delegate.getClient();
    }

    public ClientConfiguration getClientConfiguration() {
        return this.delegate.getClientConfiguration();
    }

    public Endpoint getEndpoint(String resource) {
        return this.delegate.getEndpoint(resource);
    }

    public boolean hasEndpoint(String urlPattern) {
        return this.delegate.hasEndpoint(urlPattern);
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public Set<DataProvider> getDataProviders() {
        return this.delegate.getDataProviders();
    }

    public void addCheck(Check check) {
        this.extraCheck.add(check);
    }

    public void addChecks(Collection<Check> checks) {
        this.extraCheck.addAll(checks);
    }

    public boolean isDefaultChecks() {
        return this.defaultChecks;
    }

    public void setDefaultChecks(boolean defaultChecks) {
        this.defaultChecks = defaultChecks;
    }

    static {
        LinkedList<Check> dc = new LinkedList<Check>();
        dc.add(new Check(UnknownHostException.class));
        dc.add(new Check(SocketTimeoutException.class));
        dc.add(new Check(IOException.class, "Connection refused"));
        dc.add(new Check(IOException.class, "Server returned HTTP response code: 50"));
        dc.add(new Check(ConnectException.class, "unreachable"));
        DEFAULT_CHECKS = Collections.unmodifiableList(dc);
    }

    public static class Check {
        private final Class<? extends Throwable> throwable;
        private final Pattern messagePattern;
        private boolean checkStack = true;
        private String infoMessage;

        public Check(Class<? extends Throwable> throwable) {
            this(throwable, (Pattern)null);
        }

        public Check(Class<? extends Throwable> throwable, String message) {
            this(throwable, Pattern.compile(Pattern.quote(message), 2));
            this.infoMessage = String.format("Ignoring because of %s(\"%s\")", throwable.getSimpleName(), message);
        }

        public Check(Class<? extends Throwable> throwable, Pattern mPattern) {
            this.throwable = throwable;
            this.messagePattern = mPattern;
            this.infoMessage = String.format("Ignoring because of %s", throwable.getSimpleName());
        }

        public Check setCheckStack(boolean checkStack) {
            this.checkStack = checkStack;
            return this;
        }

        public <T extends Throwable> void matches(T t) throws T {
            this.matches(t, t);
        }

        private <T extends Throwable> void matches(T t, Throwable toCheck) throws T {
            if (toCheck == null) {
                return;
            }
            if (this.throwable.isAssignableFrom(toCheck.getClass()) && (this.messagePattern == null || toCheck.getMessage() != null && this.messagePattern.matcher(toCheck.getMessage()).find())) {
                log.info("Ignoring test because '{}' ({})", (Object)this.getMessage(), (Object)t.getMessage());
                Assume.assumeNoException((String)this.getMessage(), t);
                throw t;
            }
            if (this.checkStack) {
                this.matches(t, toCheck.getCause());
            }
        }

        public String getMessage() {
            return this.infoMessage;
        }

        public Check setMessage(String infoMessage) {
            this.infoMessage = infoMessage;
            return this;
        }
    }
}

