/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldcache.services;

import info.aduna.iteration.CloseableIteration;
import java.util.Date;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.marmotta.commons.locking.ObjectLocks;
import org.apache.marmotta.ldcache.api.LDCachingBackend;
import org.apache.marmotta.ldcache.api.LDCachingConnection;
import org.apache.marmotta.ldcache.api.LDCachingService;
import org.apache.marmotta.ldcache.model.CacheConfiguration;
import org.apache.marmotta.ldcache.model.CacheEntry;
import org.apache.marmotta.ldclient.api.ldclient.LDClientService;
import org.apache.marmotta.ldclient.services.ldclient.LDClient;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDCache
implements LDCachingService {
    private static Logger log = LoggerFactory.getLogger(LDCache.class);
    private ObjectLocks resourceLocks;
    private LDClientService ldclient;
    private LDCachingBackend backend;
    private CacheConfiguration config;
    private ReentrantReadWriteLock lock;

    public LDCache(CacheConfiguration config, LDCachingBackend backend) {
        log.info("Linked Data Caching Service initialising ...");
        this.resourceLocks = new ObjectLocks();
        this.backend = backend;
        this.ldclient = new LDClient(config.getClientConfiguration());
        this.config = config;
        this.lock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        this.lock.writeLock().lock();
        try {
            if (this.ldclient != null) {
                log.info("Reloading LDClient configuration ...");
                this.ldclient.shutdown();
                this.ldclient = new LDClient(this.config.getClientConfiguration());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public LDCachingConnection getCacheConnection(String resource) throws RepositoryException {
        return this.backend.getCacheConnection(resource);
    }

    public CloseableIteration<CacheEntry, RepositoryException> listCacheEntries() throws RepositoryException {
        return this.backend.listCacheEntries();
    }

    public CloseableIteration<CacheEntry, RepositoryException> listExpiredEntries() throws RepositoryException {
        return this.backend.listExpiredEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(String resourceUri) throws RepositoryException {
        if (!this.backend.isCached(resourceUri)) {
            return false;
        }
        LDCachingConnection con = this.backend.getCacheConnection(resourceUri);
        try {
            con.begin();
            boolean bl = con.hasStatement((Resource)con.getValueFactory().createURI(resourceUri), null, null, false, new Resource[0]);
            return bl;
        }
        finally {
            con.commit();
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(URI resource) {
        Date now = new Date();
        try (LDCachingConnection con = this.backend.getCacheConnection(resource.stringValue());){
            con.begin();
            CacheEntry entry = con.getCacheEntry(resource);
            if (entry.getExpiryDate().getTime() > now.getTime()) {
                entry.setExpiryDate(now);
                con.removeCacheEntry(entry.getResource());
                con.addCacheEntry(entry.getResource(), entry);
            }
            con.commit();
        }
        catch (RepositoryException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    public void refreshResource(URI resource, boolean forceRefresh) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshExpired() {
        Date now = new Date();
        try (CloseableIteration it = this.backend.listExpiredEntries();){
            while (it.hasNext()) {
                CacheEntry next = (CacheEntry)it.next();
                if (next.getExpiryDate().getTime() >= now.getTime()) continue;
                this.refreshResource(next.getResource(), false);
            }
        }
        catch (RepositoryException ex) {
            log.error("exception while refreshing cache entries", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireAll() {
        block14: {
            Date now = new Date();
            try {
                CloseableIteration it = this.backend.listCacheEntries();
                block12: while (true) {
                    while (it.hasNext()) {
                        CacheEntry next = (CacheEntry)it.next();
                        if (next.getExpiryDate().getTime() <= now.getTime()) continue;
                        next.setExpiryDate(now);
                        try {
                            LDCachingConnection con = this.backend.getCacheConnection(next.getResource().stringValue());
                            try {
                                con.begin();
                                con.removeCacheEntry(next.getResource());
                                con.addCacheEntry(next.getResource(), next);
                                con.commit();
                                continue block12;
                            }
                            catch (RepositoryException ex) {
                                con.rollback();
                                continue block12;
                            }
                            finally {
                                con.close();
                                continue block12;
                            }
                        }
                        catch (RepositoryException ex) {
                        }
                    }
                    break block14;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    it.close();
                }
            }
            catch (RepositoryException ex) {
                log.error("exception while expiring cache entries", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.lock.writeLock().lock();
        try {
            this.backend.shutdown();
            this.ldclient.shutdown();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public LDClientService getLDClient() {
        return this.ldclient;
    }
}

