/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.versioning.sail;

import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.marmotta.commons.sesame.filter.AlwaysTrueFilter;
import org.apache.marmotta.commons.sesame.filter.SesameFilter;
import org.apache.marmotta.kiwi.model.rdf.KiWiResource;
import org.apache.marmotta.kiwi.sail.KiWiStore;
import org.apache.marmotta.kiwi.transactions.api.TransactionListener;
import org.apache.marmotta.kiwi.transactions.api.TransactionalSail;
import org.apache.marmotta.kiwi.transactions.model.TransactionData;
import org.apache.marmotta.kiwi.transactions.wrapper.TransactionalSailWrapper;
import org.apache.marmotta.kiwi.versioning.api.VersioningSail;
import org.apache.marmotta.kiwi.versioning.model.Version;
import org.apache.marmotta.kiwi.versioning.persistence.KiWiVersioningConnection;
import org.apache.marmotta.kiwi.versioning.persistence.KiWiVersioningPersistence;
import org.apache.marmotta.kiwi.versioning.sail.KiWiSnapshotConnection;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.sail.SailException;
import org.openrdf.sail.StackableSail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiWiVersioningSail
extends TransactionalSailWrapper
implements TransactionListener,
VersioningSail {
    private static Logger log = LoggerFactory.getLogger(KiWiVersioningSail.class);
    protected static final long DEFAULT_CONNECTION_TIMEOUT = 20000L;
    private KiWiVersioningPersistence persistence = new KiWiVersioningPersistence(this.getBaseStore().getPersistence());
    private Set<KiWiSnapshotConnection> activeSnapshots = new HashSet<KiWiSnapshotConnection>();
    private SesameFilter<Statement> filter;

    public KiWiVersioningSail(TransactionalSail parent) {
        this(parent, (SesameFilter<Statement>)new AlwaysTrueFilter());
    }

    public KiWiVersioningSail(TransactionalSail parent, SesameFilter<Statement> filter) {
        super(parent);
        this.filter = filter;
        parent.addTransactionListener((TransactionListener)this);
    }

    public void initialize() throws SailException {
        super.initialize();
        try {
            this.persistence.initDatabase();
        }
        catch (SQLException e) {
            throw new SailException("error while initialising versioning tables in database", (Throwable)e);
        }
    }

    public KiWiStore getBaseStore() {
        KiWiVersioningSail current;
        for (current = this; current != null && current.getBaseSail() instanceof StackableSail; current = (StackableSail)current.getBaseSail()) {
        }
        if (current != null && current.getBaseSail() instanceof KiWiStore) {
            return (KiWiStore)current.getBaseSail();
        }
        throw new IllegalStateException("the base store is not a KiWiStore (type: " + current.getBaseSail().getClass().getCanonicalName() + ")!");
    }

    public KiWiVersioningPersistence getPersistence() {
        return this.persistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCommit(TransactionData data) {
        if (data.getAddedTriples().size() > 0 || data.getRemovedTriples().size() > 0) {
            Version version = new Version();
            version.setCommitTime(data.getCommitTime());
            for (Statement stmt : data.getAddedTriples()) {
                if (!this.filter.accept((Object)stmt)) continue;
                version.getAddedTriples().add(stmt);
            }
            for (Statement stmt : data.getRemovedTriples()) {
                if (!this.filter.accept((Object)stmt)) continue;
                version.getRemovedTriples().add(stmt);
            }
            if (version.getAddedTriples().size() > 0 || version.getRemovedTriples().size() > 0) {
                try {
                    KiWiVersioningConnection connection = this.persistence.getConnection();
                    try {
                        connection.storeVersion(version);
                        connection.commit();
                    }
                    catch (SQLException ex) {
                        log.warn("could not store versioning information (error: {}); rolling back...", (Object)ex.getMessage());
                        connection.rollback();
                    }
                    finally {
                        connection.close();
                    }
                }
                catch (SQLException ex) {
                    log.warn("could not store versioning information (error: {})", (Object)ex.getMessage());
                }
            }
        }
    }

    public void beforeCommit(TransactionData data) {
    }

    public void rollback(TransactionData data) {
    }

    @Override
    public KiWiSnapshotConnection getSnapshot(Date snapshotDate) throws SailException {
        KiWiSnapshotConnection con = new KiWiSnapshotConnection(this, snapshotDate);
        this.activeSnapshots.add(con);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSnapshotConnection(KiWiSnapshotConnection con) {
        Set<KiWiSnapshotConnection> set = this.activeSnapshots;
        synchronized (set) {
            this.activeSnapshots.remove(con);
            if (this.activeSnapshots.isEmpty()) {
                this.activeSnapshots.notifyAll();
            }
        }
    }

    @Override
    public RepositoryResult<Version> listVersions() throws SailException {
        try {
            final KiWiVersioningConnection connection = this.persistence.getConnection();
            return new RepositoryResult<Version>(connection.listVersions()){

                protected void handleClose() throws RepositoryException {
                    super.handleClose();
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (SQLException ex) {
                        throw new RepositoryException("database error while committing/closing connection");
                    }
                }
            };
        }
        catch (SQLException ex) {
            throw new SailException("database error while listing versions", (Throwable)ex);
        }
    }

    @Override
    public RepositoryResult<Version> listVersions(Date from, Date to) throws SailException {
        try {
            final KiWiVersioningConnection connection = this.persistence.getConnection();
            return new RepositoryResult<Version>(connection.listVersions(from, to)){

                protected void handleClose() throws RepositoryException {
                    super.handleClose();
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (SQLException ex) {
                        throw new RepositoryException("database error while committing/closing connection");
                    }
                }
            };
        }
        catch (SQLException ex) {
            throw new SailException("database error while listing versions", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version getVersion(Long id) throws SailException {
        Version version;
        KiWiVersioningConnection connection = this.persistence.getConnection();
        try {
            version = connection.getVersion(id);
        }
        catch (Throwable throwable) {
            try {
                connection.commit();
                connection.close();
                throw throwable;
            }
            catch (SQLException ex) {
                throw new SailException("database error while listing versions", (Throwable)ex);
            }
        }
        connection.commit();
        connection.close();
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version getLatestVersion(Resource r, Date date) throws SailException {
        Version version;
        KiWiVersioningConnection connection = this.persistence.getConnection();
        KiWiResource kr = (KiWiResource)(r instanceof URI ? this.getValueFactory().createURI(r.stringValue()) : this.getValueFactory().createBNode(r.stringValue()));
        try {
            version = connection.getLatestVersion(kr, date);
        }
        catch (Throwable throwable) {
            try {
                connection.commit();
                connection.close();
                throw throwable;
            }
            catch (SQLException ex) {
                throw new SailException("database error while listing versions", (Throwable)ex);
            }
        }
        connection.commit();
        connection.close();
        return version;
    }

    @Override
    public RepositoryResult<Version> listVersions(Resource r) throws SailException {
        try {
            final KiWiVersioningConnection connection = this.persistence.getConnection();
            KiWiResource kr = (KiWiResource)(r instanceof URI ? this.getValueFactory().createURI(r.stringValue()) : this.getValueFactory().createBNode(r.stringValue()));
            return new RepositoryResult<Version>(connection.listVersions(kr)){

                protected void handleClose() throws RepositoryException {
                    super.handleClose();
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (SQLException ex) {
                        throw new RepositoryException("database error while committing/closing connection");
                    }
                }
            };
        }
        catch (SQLException ex) {
            throw new SailException("database error while listing versions", (Throwable)ex);
        }
    }

    @Override
    public RepositoryResult<Version> listVersions(Resource r, Date from, Date to) throws SailException {
        try {
            final KiWiVersioningConnection connection = this.persistence.getConnection();
            KiWiResource kr = (KiWiResource)(r instanceof URI ? this.getValueFactory().createURI(r.stringValue()) : this.getValueFactory().createBNode(r.stringValue()));
            return new RepositoryResult<Version>(connection.listVersions(kr, from, to)){

                protected void handleClose() throws RepositoryException {
                    super.handleClose();
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (SQLException ex) {
                        throw new RepositoryException("database error while committing/closing connection");
                    }
                }
            };
        }
        catch (SQLException ex) {
            throw new SailException("database error while listing versions", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() throws SailException {
        Set<KiWiSnapshotConnection> set = this.activeSnapshots;
        synchronized (set) {
            if (!this.activeSnapshots.isEmpty()) {
                log.warn("waiting for open connections ({}) to finish ...", (Object)this.activeSnapshots.size());
                try {
                    this.activeSnapshots.wait(20000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                HashSet<KiWiSnapshotConnection> connectionCopy = new HashSet<KiWiSnapshotConnection>(this.activeSnapshots);
                for (KiWiSnapshotConnection con : connectionCopy) {
                    if (con.isActive()) {
                        con.rollback();
                    }
                    if (!con.isOpen()) continue;
                    con.close();
                }
            }
        }
        super.shutDown();
    }
}

