/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.versioning.persistence;

import java.sql.SQLException;
import org.apache.marmotta.kiwi.persistence.KiWiDialect;
import org.apache.marmotta.kiwi.persistence.KiWiPersistence;
import org.apache.marmotta.kiwi.versioning.persistence.KiWiVersioningConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiWiVersioningPersistence {
    private static Logger log = LoggerFactory.getLogger(KiWiVersioningPersistence.class);
    private KiWiPersistence persistence;

    public KiWiVersioningPersistence(KiWiPersistence persistence) {
        this.persistence = persistence;
        persistence.addNodeTableDependency("versions", "creator");
        persistence.addTripleTableDependency("versions_added", "triple_id");
        persistence.addTripleTableDependency("versions_removed", "triple_id");
    }

    public void initDatabase() throws SQLException {
        this.persistence.initDatabase("versioning", new String[]{"versions", "versions_added", "versions_removed"});
    }

    public void dropDatabase() throws SQLException {
        this.persistence.dropDatabase("versioning");
    }

    public KiWiVersioningConnection getConnection() throws SQLException {
        return new KiWiVersioningConnection(this.persistence, this.persistence.getDialect(), this.persistence.getCacheManager());
    }

    public KiWiDialect getDialect() {
        return this.persistence.getDialect();
    }
}

