/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.versioning.persistence;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.marmotta.kiwi.caching.KiWiCacheManager;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiTriple;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;
import org.apache.marmotta.kiwi.persistence.KiWiConnection;
import org.apache.marmotta.kiwi.persistence.KiWiDialect;
import org.apache.marmotta.kiwi.persistence.KiWiPersistence;
import org.apache.marmotta.kiwi.persistence.util.ResultSetIteration;
import org.apache.marmotta.kiwi.persistence.util.ResultTransformerFunction;
import org.apache.marmotta.kiwi.versioning.model.Version;
import org.openrdf.model.Statement;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiWiVersioningConnection
extends KiWiConnection {
    private static Logger log = LoggerFactory.getLogger(KiWiVersioningConnection.class);

    public KiWiVersioningConnection(KiWiPersistence persistence, KiWiDialect dialect, KiWiCacheManager cacheManager) throws SQLException {
        super(persistence, dialect, cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeVersion(Version data) throws SQLException {
        PreparedStatement insertRemoved;
        PreparedStatement insertAdded;
        PreparedStatement insertVersion;
        if (data.getId() != null) {
            log.warn("version {} already had a version ID, not persisting", (Object)data);
            return;
        }
        this.requireJDBCConnection();
        data.setId(this.getNextSequence("seq.versions"));
        PreparedStatement preparedStatement = insertVersion = this.getPreparedStatement("store.version");
        synchronized (preparedStatement) {
            insertVersion.setLong(1, data.getId());
            if (data.getCreator() != null) {
                insertVersion.setLong(2, data.getCreator().getId());
            } else {
                insertVersion.setObject(2, null);
            }
            insertVersion.setTimestamp(3, new Timestamp(data.getCommitTime().getTime()));
            insertVersion.executeUpdate();
        }
        PreparedStatement preparedStatement2 = insertAdded = this.getPreparedStatement("store.version_added");
        synchronized (preparedStatement2) {
            insertAdded.clearParameters();
            for (Statement added : data.getAddedTriples()) {
                if (added instanceof KiWiTriple) {
                    insertAdded.setLong(1, data.getId());
                    insertAdded.setLong(2, ((KiWiTriple)added).getId());
                    insertAdded.addBatch();
                    continue;
                }
                log.warn("cannot create version with statements that are not instances of KiWiTriple!");
            }
            insertAdded.executeBatch();
        }
        PreparedStatement preparedStatement3 = insertRemoved = this.getPreparedStatement("store.version_removed");
        synchronized (preparedStatement3) {
            insertRemoved.clearParameters();
            for (Statement added : data.getRemovedTriples()) {
                if (added instanceof KiWiTriple) {
                    insertRemoved.setLong(1, data.getId());
                    insertRemoved.setLong(2, ((KiWiTriple)added).getId());
                    insertRemoved.addBatch();
                    continue;
                }
                log.warn("cannot create version with statements that are not instances of KiWiTriple!");
            }
            insertRemoved.executeBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version getVersion(Long id) throws SQLException {
        this.requireJDBCConnection();
        PreparedStatement queryVersions = this.getPreparedStatement("load.version_by_id");
        queryVersions.setLong(1, id);
        queryVersions.setMaxRows(1);
        ResultSet r = queryVersions.executeQuery();
        try {
            if (r.next()) {
                Version version = this.constructVersionFromDatabase(r);
                return version;
            }
            Version version = null;
            return version;
        }
        finally {
            r.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Version getLatestVersion(KiWiResource resource, Date date) throws SQLException {
        PreparedStatement queryVersions;
        this.requireJDBCConnection();
        PreparedStatement preparedStatement = queryVersions = this.getPreparedStatement("load.versions_by_resource_latest");
        synchronized (preparedStatement) {
            queryVersions.setLong(1, resource.getId());
            queryVersions.setTimestamp(2, new Timestamp(date.getTime()));
            queryVersions.setMaxRows(1);
            ResultSet r = queryVersions.executeQuery();
            try {
                if (r.next()) {
                    Version version = this.constructVersionFromDatabase(r);
                    return version;
                }
                Version version = null;
                return version;
            }
            finally {
                r.close();
            }
        }
    }

    public RepositoryResult<Version> listVersions() throws SQLException {
        return new RepositoryResult((CloseableIteration)new ExceptionConvertingIteration<Version, RepositoryException>(this.listVersionsInternal()){

            protected RepositoryException convert(Exception e) {
                return new RepositoryException("database error while iterating over result set", (Throwable)e);
            }
        });
    }

    private CloseableIteration<Version, SQLException> listVersionsInternal() throws SQLException {
        this.requireJDBCConnection();
        PreparedStatement queryVersions = this.getPreparedStatement("load.versions");
        final ResultSet result = queryVersions.executeQuery();
        return new ResultSetIteration(result, (ResultTransformerFunction)new ResultTransformerFunction<Version>(){

            public Version apply(ResultSet row) throws SQLException {
                return KiWiVersioningConnection.this.constructVersionFromDatabase(result);
            }
        });
    }

    public RepositoryResult<Version> listVersions(KiWiResource r) throws SQLException {
        return new RepositoryResult((CloseableIteration)new ExceptionConvertingIteration<Version, RepositoryException>(this.listVersionsInternal(r)){

            protected RepositoryException convert(Exception e) {
                return new RepositoryException("database error while iterating over result set", (Throwable)e);
            }
        });
    }

    private CloseableIteration<Version, SQLException> listVersionsInternal(KiWiResource r) throws SQLException {
        if (r.getId() == null) {
            return new EmptyIteration();
        }
        this.requireJDBCConnection();
        PreparedStatement queryVersions = this.getPreparedStatement("load.versions_by_resource");
        queryVersions.setLong(1, r.getId());
        final ResultSet result = queryVersions.executeQuery();
        return new ResultSetIteration(result, (ResultTransformerFunction)new ResultTransformerFunction<Version>(){

            public Version apply(ResultSet row) throws SQLException {
                return KiWiVersioningConnection.this.constructVersionFromDatabase(result);
            }
        });
    }

    public RepositoryResult<Version> listVersions(Date from, Date to) throws SQLException {
        return new RepositoryResult((CloseableIteration)new ExceptionConvertingIteration<Version, RepositoryException>(this.listVersionsInternal(from, to)){

            protected RepositoryException convert(Exception e) {
                return new RepositoryException("database error while iterating over result set", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableIteration<Version, SQLException> listVersionsInternal(Date from, Date to) throws SQLException {
        PreparedStatement queryVersions;
        this.requireJDBCConnection();
        PreparedStatement preparedStatement = queryVersions = this.getPreparedStatement("load.version_between");
        synchronized (preparedStatement) {
            queryVersions.clearParameters();
            queryVersions.setTimestamp(1, new Timestamp(from.getTime()));
            queryVersions.setTimestamp(2, new Timestamp(to.getTime()));
            final ResultSet result = queryVersions.executeQuery();
            return new ResultSetIteration(result, (ResultTransformerFunction)new ResultTransformerFunction<Version>(){

                public Version apply(ResultSet row) throws SQLException {
                    return KiWiVersioningConnection.this.constructVersionFromDatabase(result);
                }
            });
        }
    }

    public RepositoryResult<Version> listVersions(KiWiResource r, Date from, Date to) throws SQLException {
        return new RepositoryResult((CloseableIteration)new ExceptionConvertingIteration<Version, RepositoryException>(this.listVersionsInternal(r, from, to)){

            protected RepositoryException convert(Exception e) {
                return new RepositoryException("database error while iterating over result set", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableIteration<Version, SQLException> listVersionsInternal(KiWiResource r, Date from, Date to) throws SQLException {
        PreparedStatement queryVersions;
        this.requireJDBCConnection();
        PreparedStatement preparedStatement = queryVersions = this.getPreparedStatement("load.versions_by_resource_between");
        synchronized (preparedStatement) {
            queryVersions.clearParameters();
            if (r.getId() == null) {
                return new EmptyIteration();
            }
            queryVersions.setLong(1, r.getId());
            queryVersions.setTimestamp(2, new Timestamp(from.getTime()));
            queryVersions.setTimestamp(3, new Timestamp(to.getTime()));
            final ResultSet result = queryVersions.executeQuery();
            return new ResultSetIteration(result, (ResultTransformerFunction)new ResultTransformerFunction<Version>(){

                public Version apply(ResultSet row) throws SQLException {
                    return KiWiVersioningConnection.this.constructVersionFromDatabase(result);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Version constructVersionFromDatabase(ResultSet row) throws SQLException {
        PreparedStatement queryRemoved;
        PreparedStatement queryAdded;
        Version result = new Version(row.getLong("id"));
        result.setCommitTime(new Date(row.getTimestamp("createdAt").getTime()));
        if (row.getObject("creator") != null) {
            result.setCreator((KiWiResource)this.loadNodeById(row.getLong("creator")));
        }
        PreparedStatement preparedStatement = queryAdded = this.getPreparedStatement("load.versions_added");
        synchronized (preparedStatement) {
            queryAdded.clearParameters();
            queryAdded.setLong(1, result.getId());
            ResultSet addedRow = queryAdded.executeQuery();
            try {
                while (addedRow.next()) {
                    result.addTriple((Statement)this.loadTripleById(addedRow.getLong("triple_id")));
                }
            }
            finally {
                addedRow.close();
            }
        }
        PreparedStatement preparedStatement2 = queryRemoved = this.getPreparedStatement("load.versions_removed");
        synchronized (preparedStatement2) {
            queryRemoved.clearParameters();
            queryRemoved.setLong(1, result.getId());
            ResultSet removedRow = queryRemoved.executeQuery();
            try {
                while (removedRow.next()) {
                    result.removeTriple((Statement)this.loadTripleById(removedRow.getLong("triple_id")));
                }
            }
            finally {
                removedRow.close();
            }
        }
        return result;
    }

    public RepositoryResult<Statement> listTriplesSnapshot(KiWiResource subject, KiWiUriResource predicate, KiWiNode object, KiWiResource context, boolean inferred, Date snapshotDate) throws SQLException {
        return new RepositoryResult((CloseableIteration)new ExceptionConvertingIteration<Statement, RepositoryException>(this.listTriplesInternalSnapshot(subject, predicate, object, context, inferred, snapshotDate)){

            protected RepositoryException convert(Exception e) {
                return new RepositoryException("database error while iterating over result set", (Throwable)e);
            }
        });
    }

    private CloseableIteration<Statement, SQLException> listTriplesInternalSnapshot(KiWiResource subject, KiWiUriResource predicate, KiWiNode object, KiWiResource context, boolean inferred, Date snapshotDate) throws SQLException {
        if (subject != null && subject.getId() == null) {
            return new EmptyIteration();
        }
        if (predicate != null && predicate.getId() == null) {
            return new EmptyIteration();
        }
        if (object != null && object.getId() == null) {
            return new EmptyIteration();
        }
        if (context != null && context.getId() == null) {
            return new EmptyIteration();
        }
        this.requireJDBCConnection();
        PreparedStatement query = this.connection.prepareStatement(this.constructTripleQuerySnapshot(subject, predicate, object, context, inferred, snapshotDate), 1003, 1007);
        query.clearParameters();
        query.setTimestamp(1, new Timestamp(snapshotDate.getTime()));
        query.setTimestamp(2, new Timestamp(snapshotDate.getTime()));
        int position = 3;
        if (subject != null) {
            query.setLong(position++, subject.getId());
        }
        if (predicate != null) {
            query.setLong(position++, predicate.getId());
        }
        if (object != null) {
            query.setLong(position++, object.getId());
        }
        if (context != null) {
            query.setLong(position++, context.getId());
        }
        final ResultSet result = query.executeQuery();
        return new ResultSetIteration(result, true, (ResultTransformerFunction)new ResultTransformerFunction<Statement>(){

            public Statement apply(ResultSet row) throws SQLException {
                return KiWiVersioningConnection.this.constructTripleFromDatabase(result);
            }
        });
    }

    protected String constructTripleQuerySnapshot(KiWiResource subject, KiWiUriResource predicate, KiWiNode object, KiWiResource context, boolean inferred, Date snapshotDate) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id,subject,predicate,object,context,deleted,inferred,creator,createdAt,deletedAt FROM triples");
        builder.append(" WHERE  createdAt <= ? AND (deleted = false OR deletedAt > ?)");
        if (subject != null) {
            builder.append(" AND subject = ?");
        }
        if (predicate != null) {
            builder.append(" AND predicate = ?");
        }
        if (object != null) {
            builder.append(" AND object = ?");
        }
        if (context != null) {
            builder.append(" AND context = ?");
        }
        if (!inferred) {
            builder.append(" AND inferred = false");
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSnapshotSize(Date snapshotDate) throws SQLException {
        PreparedStatement querySize = this.getPreparedStatement("query.snapshot_size");
        querySize.setTimestamp(1, new Timestamp(snapshotDate.getTime()));
        querySize.setTimestamp(2, new Timestamp(snapshotDate.getTime()));
        ResultSet result = querySize.executeQuery();
        try {
            if (result.next()) {
                long l = result.getLong(1);
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSnapshotSize(KiWiResource context, Date snapshotDate) throws SQLException {
        if (context.getId() == null) {
            return 0L;
        }
        this.requireJDBCConnection();
        PreparedStatement querySize = this.getPreparedStatement("query.snapshot_size_ctx");
        querySize.setLong(1, context.getId());
        querySize.setTimestamp(2, new Timestamp(snapshotDate.getTime()));
        querySize.setTimestamp(3, new Timestamp(snapshotDate.getTime()));
        ResultSet result = querySize.executeQuery();
        try {
            if (result.next()) {
                long l = result.getLong(1);
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            result.close();
        }
    }
}

