/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.ehcache.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

public class CacheMap<K, V>
implements Map<K, V> {
    private Cache delegate;

    public CacheMap(Cache delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.delegate.getSize();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.getSize() == 0;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.delegate.isKeyInCache(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.delegate.isValueInCache(o);
    }

    @Override
    public V get(Object o) {
        Element e = this.delegate.get(o);
        if (e != null) {
            return (V)e.getObjectValue();
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        Element e = this.delegate.get(k);
        this.delegate.put(new Element(k, v));
        if (e != null) {
            return (V)e.getObjectValue();
        }
        return null;
    }

    @Override
    public V remove(Object o) {
        Element e = this.delegate.removeAndReturnElement(o);
        if (e != null) {
            return (V)e.getObjectValue();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.delegate.removeAll();
    }

    @Override
    public Set<K> keySet() {
        return ImmutableSet.copyOf((Collection)this.delegate.getKeys());
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("listing values not supported by cache");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return ImmutableSet.copyOf((Collection)Collections2.transform((Collection)this.delegate.getKeys(), (Function)new Function<K, Map.Entry<K, V>>(){

            public Map.Entry<K, V> apply(final K input) {
                final Element e = CacheMap.this.delegate.get(input);
                return new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return input;
                    }

                    @Override
                    public V getValue() {
                        return e.getObjectValue();
                    }

                    @Override
                    public V setValue(V v) {
                        CacheMap.this.delegate.put(new Element(input, v));
                        return e.getObjectValue();
                    }
                };
            }
        }));
    }
}

