/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.kiwi.ehcache.caching;

import java.net.URL;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import org.apache.marmotta.kiwi.config.KiWiConfiguration;
import org.apache.marmotta.kiwi.ehcache.util.CacheMap;
import org.apache.marmotta.kiwi.model.rdf.KiWiAnonResource;
import org.apache.marmotta.kiwi.model.rdf.KiWiLiteral;
import org.apache.marmotta.kiwi.model.rdf.KiWiNamespace;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiTriple;
import org.apache.marmotta.kiwi.model.rdf.KiWiUriResource;

public class EHCacheManager
implements org.apache.marmotta.kiwi.caching.CacheManager {
    private CacheManager cacheManager = CacheManager.newInstance((URL)EHCacheManager.class.getResource("/ehcache-kiwi.xml"));
    private CacheMap<Long, KiWiNode> nodeCache;
    private CacheMap<Long, KiWiTriple> tripleCache;
    private CacheMap<String, KiWiUriResource> uriCache;
    private CacheMap<String, KiWiAnonResource> bnodeCache;
    private CacheMap<String, KiWiLiteral> literalCache;
    private CacheMap<String, KiWiNamespace> nsPrefixCache;
    private CacheMap<String, KiWiNamespace> nsUriCache;
    private CacheMap<Long, Long> registryCache;

    public EHCacheManager(KiWiConfiguration configuration) {
        if (configuration.getClusterName() != null) {
            this.cacheManager.setName(configuration.getClusterName());
        }
    }

    public Map<Long, KiWiNode> getNodeCache() {
        if (this.nodeCache == null) {
            this.nodeCache = new CacheMap(this.cacheManager.getCache("node-cache"));
        }
        return this.nodeCache;
    }

    public Map<Long, KiWiTriple> getTripleCache() {
        if (this.tripleCache == null) {
            this.tripleCache = new CacheMap(this.cacheManager.getCache("triple-cache"));
        }
        return this.tripleCache;
    }

    public Map<String, KiWiUriResource> getUriCache() {
        if (this.uriCache == null) {
            this.uriCache = new CacheMap(this.cacheManager.getCache("uri-cache"));
        }
        return this.uriCache;
    }

    public Map<String, KiWiAnonResource> getBNodeCache() {
        if (this.bnodeCache == null) {
            this.bnodeCache = new CacheMap(this.cacheManager.getCache("bnode-cache"));
        }
        return this.bnodeCache;
    }

    public Map<String, KiWiLiteral> getLiteralCache() {
        if (this.literalCache == null) {
            this.literalCache = new CacheMap(this.cacheManager.getCache("literal-cache"));
        }
        return this.literalCache;
    }

    public Map<String, KiWiNamespace> getNamespaceUriCache() {
        if (this.nsUriCache == null) {
            this.nsUriCache = new CacheMap(this.cacheManager.getCache("namespace-uri-cache"));
        }
        return this.nsUriCache;
    }

    public Map<String, KiWiNamespace> getNamespacePrefixCache() {
        if (this.nsPrefixCache == null) {
            this.nsPrefixCache = new CacheMap(this.cacheManager.getCache("namespace-prefix-cache"));
        }
        return this.nsPrefixCache;
    }

    public Map<Long, Long> getRegistryCache() {
        if (this.registryCache == null) {
            this.registryCache = new CacheMap(this.cacheManager.getCache("registry-cache"));
        }
        return this.registryCache;
    }

    public Map getCacheByName(String name) {
        return new CacheMap(this.cacheManager.getCache(name));
    }

    public void clear() {
        this.cacheManager.clearAll();
    }

    public void shutdown() {
        this.cacheManager.shutdown();
    }
}

