/*
 * Decompiled with CFR 0.152.
 */
package org.kosmix.kosmosfs.access;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.kosmix.kosmosfs.access.Positionable;

public class KfsOutputChannel
implements WritableByteChannel,
Positionable {
    private static final int DEFAULT_BUF_SIZE = 0x100000;
    private ByteBuffer writeBuffer = ByteBuffer.allocateDirect(0x100000);
    private int kfsFd = -1;
    private long cPtr;

    private static final native int close(long var0, int var2);

    private static final native int write(long var0, int var2, ByteBuffer var3, int var4, int var5);

    private static final native int sync(long var0, int var2);

    private static final native int seek(long var0, int var2, long var3);

    private static final native long tell(long var0, int var2);

    public KfsOutputChannel(long ptr, int fd) {
        this.writeBuffer.clear();
        this.kfsFd = fd;
        this.cPtr = ptr;
    }

    @Override
    public boolean isOpen() {
        return this.kfsFd > 0;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.kfsFd < 0) {
            throw new IOException("File closed");
        }
        int r0 = src.remaining();
        while (src.hasRemaining()) {
            if (this.writeBuffer.remaining() == 0) {
                this.writeBuffer.flip();
                this.writeDirect(this.writeBuffer);
            }
            int lim = src.limit();
            if (this.writeBuffer.remaining() < src.remaining()) {
                src.limit(src.position() + this.writeBuffer.remaining());
            }
            this.writeBuffer.put(src);
            src.limit(lim);
        }
        int r1 = src.remaining();
        return r0 - r1;
    }

    private void writeDirect(ByteBuffer buf) throws IOException {
        if (!buf.isDirect()) {
            throw new IllegalArgumentException("need direct buffer");
        }
        int pos = buf.position();
        int last = buf.limit();
        if (last - pos == 0) {
            return;
        }
        int sz = KfsOutputChannel.write(this.cPtr, this.kfsFd, buf, pos, last);
        if (sz < 0) {
            throw new IOException("writeDirect failed");
        }
        if (sz == last) {
            buf.clear();
            return;
        }
        if (sz == 0) {
            return;
        }
        ByteBuffer temp = ByteBuffer.allocateDirect(0x100000);
        temp.put(buf);
        temp.flip();
        buf.clear();
        buf.put(temp);
    }

    public int sync() throws IOException {
        if (this.kfsFd < 0) {
            throw new IOException("File closed");
        }
        this.writeBuffer.flip();
        this.writeDirect(this.writeBuffer);
        return KfsOutputChannel.sync(this.cPtr, this.kfsFd);
    }

    @Override
    public int seek(long offset) throws IOException {
        if (this.kfsFd < 0) {
            throw new IOException("File closed");
        }
        this.sync();
        return KfsOutputChannel.seek(this.cPtr, this.kfsFd, offset);
    }

    @Override
    public long tell() throws IOException {
        if (this.kfsFd < 0) {
            throw new IOException("File closed");
        }
        return KfsOutputChannel.tell(this.cPtr, this.kfsFd);
    }

    @Override
    public void close() throws IOException {
        if (this.kfsFd < 0) {
            return;
        }
        this.sync();
        KfsOutputChannel.close(this.cPtr, this.kfsFd);
        this.kfsFd = -1;
    }

    protected void finalize() throws Throwable {
        if (this.kfsFd < 0) {
            return;
        }
        this.close();
    }
}

