/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import junit.framework.Assert;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.CheckHits;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util._TestUtil;

public class QueryUtils {
    public static void check(Query q) {
        QueryUtils.checkHashEquals(q);
    }

    public static void checkHashEquals(Query q) {
        Query q2 = (Query)q.clone();
        QueryUtils.checkEqual(q, q2);
        Query q3 = (Query)q.clone();
        q3.setBoost(7.2179236f);
        QueryUtils.checkUnequal(q, q3);
        Query whacky = new Query(){

            public String toString(String field) {
                return "My Whacky Query";
            }
        };
        whacky.setBoost(q.getBoost());
        QueryUtils.checkUnequal(q, whacky);
        Assert.assertFalse((boolean)q.equals(null));
    }

    public static void checkEqual(Query q1, Query q2) {
        Assert.assertEquals((Object)q1, (Object)q2);
        Assert.assertEquals((int)q1.hashCode(), (int)q2.hashCode());
    }

    public static void checkUnequal(Query q1, Query q2) {
        Assert.assertTrue((!q1.equals((Object)q2) ? 1 : 0) != 0);
        Assert.assertTrue((!q2.equals((Object)q1) ? 1 : 0) != 0);
        Assert.assertTrue((q1.hashCode() != q2.hashCode() ? 1 : 0) != 0);
    }

    public static void checkExplanations(Query q, Searcher s) throws IOException {
        CheckHits.checkExplanations(q, null, s, true);
    }

    public static void check(Random random, Query q1, Searcher s) {
        QueryUtils.check(random, q1, s, true);
    }

    private static void check(Random random, Query q1, Searcher s, boolean wrap) {
        try {
            QueryUtils.check(q1);
            if (s != null) {
                if (s instanceof IndexSearcher) {
                    IndexSearcher is = (IndexSearcher)s;
                    QueryUtils.checkFirstSkipTo(q1, is);
                    QueryUtils.checkSkipTo(q1, is);
                    if (wrap) {
                        QueryUtils.check(random, q1, (Searcher)QueryUtils.wrapUnderlyingReader(random, is, -1), false);
                        QueryUtils.check(random, q1, (Searcher)QueryUtils.wrapUnderlyingReader(random, is, 0), false);
                        QueryUtils.check(random, q1, (Searcher)QueryUtils.wrapUnderlyingReader(random, is, 1), false);
                    }
                }
                if (wrap) {
                    QueryUtils.check(random, q1, (Searcher)QueryUtils.wrapSearcher(random, s, -1), false);
                    QueryUtils.check(random, q1, (Searcher)QueryUtils.wrapSearcher(random, s, 0), false);
                    QueryUtils.check(random, q1, (Searcher)QueryUtils.wrapSearcher(random, s, 1), false);
                }
                QueryUtils.checkExplanations(q1, s);
                QueryUtils.checkSerialization(q1, s);
                Query q2 = (Query)q1.clone();
                QueryUtils.checkEqual(s.rewrite(q1), s.rewrite(q2));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static IndexSearcher wrapUnderlyingReader(Random random, IndexSearcher s, int edge) throws IOException {
        IndexReader r = s.getIndexReader();
        IndexReader[] readers = new IndexReader[]{edge < 0 ? r : IndexReader.open((Directory)QueryUtils.makeEmptyIndex(random, 0), (boolean)true), IndexReader.open((Directory)QueryUtils.makeEmptyIndex(random, 0), (boolean)true), new MultiReader(new IndexReader[]{IndexReader.open((Directory)QueryUtils.makeEmptyIndex(random, edge < 0 ? 4 : 0), (boolean)true), IndexReader.open((Directory)QueryUtils.makeEmptyIndex(random, 0), (boolean)true), 0 == edge ? r : IndexReader.open((Directory)QueryUtils.makeEmptyIndex(random, 0), (boolean)true)}), IndexReader.open((Directory)QueryUtils.makeEmptyIndex(random, 0 < edge ? 0 : 7), (boolean)true), IndexReader.open((Directory)QueryUtils.makeEmptyIndex(random, 0), (boolean)true), new MultiReader(new IndexReader[]{IndexReader.open((Directory)QueryUtils.makeEmptyIndex(random, 0 < edge ? 0 : 5), (boolean)true), IndexReader.open((Directory)QueryUtils.makeEmptyIndex(random, 0), (boolean)true), 0 < edge ? r : IndexReader.open((Directory)QueryUtils.makeEmptyIndex(random, 0), (boolean)true)})};
        IndexSearcher out = new IndexSearcher((IndexReader)new MultiReader(readers));
        out.setSimilarity(s.getSimilarity());
        return out;
    }

    public static MultiSearcher wrapSearcher(Random random, Searcher s, int edge) throws IOException {
        Searcher[] searchers = new Searcher[]{edge < 0 ? s : new IndexSearcher(QueryUtils.makeEmptyIndex(random, 0), true), new MultiSearcher((Searchable[])new Searcher[]{new IndexSearcher(QueryUtils.makeEmptyIndex(random, edge < 0 ? 65 : 0), true), new IndexSearcher(QueryUtils.makeEmptyIndex(random, 0), true), 0 == edge ? s : new IndexSearcher(QueryUtils.makeEmptyIndex(random, 0), true)}), new IndexSearcher(QueryUtils.makeEmptyIndex(random, 0 < edge ? 0 : 3), true), new IndexSearcher(QueryUtils.makeEmptyIndex(random, 0), true), new MultiSearcher((Searchable[])new Searcher[]{new IndexSearcher(QueryUtils.makeEmptyIndex(random, 0 < edge ? 0 : 5), true), new IndexSearcher(QueryUtils.makeEmptyIndex(random, 0), true), 0 < edge ? s : new IndexSearcher(QueryUtils.makeEmptyIndex(random, 0), true)})};
        MultiSearcher out = new MultiSearcher((Searchable[])searchers);
        out.setSimilarity(s.getSimilarity());
        return out;
    }

    private static Directory makeEmptyIndex(Random random, int numDeletedDocs) throws IOException {
        MockDirectoryWrapper d = new MockDirectoryWrapper(random, (Directory)new RAMDirectory());
        IndexWriter w = new IndexWriter((Directory)d, new IndexWriterConfig(LuceneTestCase.TEST_VERSION_CURRENT, (Analyzer)new MockAnalyzer(random)));
        for (int i = 0; i < numDeletedDocs; ++i) {
            w.addDocument(new Document());
        }
        w.commit();
        w.deleteDocuments((Query)new MatchAllDocsQuery());
        _TestUtil.keepFullyDeletedSegments(w);
        w.commit();
        if (0 < numDeletedDocs) {
            Assert.assertTrue((String)"writer has no deletions", (boolean)w.hasDeletions());
        }
        Assert.assertEquals((String)"writer is missing some deleted docs", (int)numDeletedDocs, (int)w.maxDoc());
        Assert.assertEquals((String)"writer has non-deleted docs", (int)0, (int)w.numDocs());
        w.close();
        IndexReader r = IndexReader.open((Directory)d, (boolean)true);
        Assert.assertEquals((String)"reader has wrong number of deleted docs", (int)numDeletedDocs, (int)r.numDeletedDocs());
        r.close();
        return d;
    }

    private static void checkSerialization(Query q, Searcher s) throws IOException {
        Weight w = q.weight(s);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(w);
            oos.close();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            IOException e2 = new IOException("Serialization failed for " + w);
            e2.initCause(e);
            throw e2;
        }
    }

    public static void checkSkipTo(final Query q, final IndexSearcher s) throws IOException {
        if (q.weight((Searcher)s).scoresDocsOutOfOrder()) {
            return;
        }
        boolean skip_op = false;
        boolean next_op = true;
        int[][] orders = new int[][]{{1}, {0}, {0, 1}, {1, 0}, {0, 0, 1, 1}, {1, 1, 0, 0}, {0, 0, 0, 1, 1}};
        for (int k = 0; k < orders.length; ++k) {
            IndexReader previousReader;
            Weight w;
            Scorer scorer;
            final int[] order = orders[k];
            final int[] opidx = new int[]{0};
            final int[] lastDoc = new int[]{-1};
            float maxDiff = 1.0E-5f;
            final IndexReader[] lastReader = new IndexReader[]{null};
            s.search(q, new Collector(){
                private Scorer sc;
                private IndexReader reader;
                private Scorer scorer;

                public void setScorer(Scorer scorer) throws IOException {
                    this.sc = scorer;
                }

                public void collect(int doc) throws IOException {
                    float score = this.sc.score();
                    lastDoc[0] = doc;
                    try {
                        if (this.scorer == null) {
                            Weight w = q.weight((Searcher)s);
                            this.scorer = w.scorer(this.reader, true, false);
                        }
                        int n = opidx[0];
                        opidx[0] = n + 1;
                        int op = order[n % order.length];
                        boolean more = op == 0 ? this.scorer.advance(this.scorer.docID() + 1) != Integer.MAX_VALUE : this.scorer.nextDoc() != Integer.MAX_VALUE;
                        int scorerDoc = this.scorer.docID();
                        float scorerScore = this.scorer.score();
                        float scorerScore2 = this.scorer.score();
                        float scoreDiff = Math.abs(score - scorerScore);
                        float scorerDiff = Math.abs(scorerScore2 - scorerScore);
                        if (!more || doc != scorerDoc || scoreDiff > 1.0E-5f || scorerDiff > 1.0E-5f) {
                            StringBuilder sbord = new StringBuilder();
                            for (int i = 0; i < order.length; ++i) {
                                sbord.append(order[i] == 0 ? " skip()" : " next()");
                            }
                            throw new RuntimeException("ERROR matching docs:\n\t" + (doc != scorerDoc ? "--> " : "") + "doc=" + doc + ", scorerDoc=" + scorerDoc + "\n\t" + (!more ? "--> " : "") + "tscorer.more=" + more + "\n\t" + (scoreDiff > 1.0E-5f ? "--> " : "") + "scorerScore=" + scorerScore + " scoreDiff=" + scoreDiff + " maxDiff=" + 1.0E-5f + "\n\t" + (scorerDiff > 1.0E-5f ? "--> " : "") + "scorerScore2=" + scorerScore2 + " scorerDiff=" + scorerDiff + "\n\thitCollector.doc=" + doc + " score=" + score + "\n\t Scorer=" + this.scorer + "\n\t Query=" + q + "  " + q.getClass().getName() + "\n\t Searcher=" + s + "\n\t Order=" + sbord + "\n\t Op=" + (op == 0 ? " skip()" : " next()"));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void setNextReader(IndexReader reader, int docBase) throws IOException {
                    IndexReader previousReader;
                    Weight w;
                    Scorer scorer;
                    if (lastReader[0] != null && (scorer = (w = q.weight((Searcher)new IndexSearcher(previousReader = lastReader[0]))).scorer(previousReader, true, false)) != null) {
                        boolean more = scorer.advance(lastDoc[0] + 1) != Integer.MAX_VALUE;
                        Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but skipTo(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
                    }
                    this.reader = lastReader[0] = reader;
                    this.scorer = null;
                    lastDoc[0] = -1;
                }

                public boolean acceptsDocsOutOfOrder() {
                    return true;
                }
            });
            if (lastReader[0] == null || (scorer = (w = q.weight((Searcher)new IndexSearcher(previousReader = lastReader[0]))).scorer(previousReader, true, false)) == null) continue;
            boolean more = scorer.advance(lastDoc[0] + 1) != Integer.MAX_VALUE;
            Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but skipTo(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
        }
    }

    private static void checkFirstSkipTo(final Query q, final IndexSearcher s) throws IOException {
        IndexReader previousReader;
        Weight w;
        Scorer scorer;
        float maxDiff = 0.001f;
        final int[] lastDoc = new int[]{-1};
        final IndexReader[] lastReader = new IndexReader[]{null};
        s.search(q, new Collector(){
            private Scorer scorer;
            private IndexReader reader;

            public void setScorer(Scorer scorer) throws IOException {
                this.scorer = scorer;
            }

            public void collect(int doc) throws IOException {
                float score = this.scorer.score();
                try {
                    for (int i = lastDoc[0] + 1; i <= doc; ++i) {
                        Weight w = q.weight((Searcher)s);
                        Scorer scorer = w.scorer(this.reader, true, false);
                        Assert.assertTrue((String)("query collected " + doc + " but skipTo(" + i + ") says no more docs!"), (scorer.advance(i) != Integer.MAX_VALUE ? 1 : 0) != 0);
                        Assert.assertEquals((String)("query collected " + doc + " but skipTo(" + i + ") got to " + scorer.docID()), (int)doc, (int)scorer.docID());
                        float skipToScore = scorer.score();
                        Assert.assertEquals((String)("unstable skipTo(" + i + ") score!"), (float)skipToScore, (float)scorer.score(), (float)0.001f);
                        Assert.assertEquals((String)("query assigned doc " + doc + " a score of <" + score + "> but skipTo(" + i + ") has <" + skipToScore + ">!"), (float)score, (float)skipToScore, (float)0.001f);
                    }
                    lastDoc[0] = doc;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void setNextReader(IndexReader reader, int docBase) throws IOException {
                IndexReader previousReader;
                Weight w;
                Scorer scorer;
                if (lastReader[0] != null && (scorer = (w = q.weight((Searcher)new IndexSearcher(previousReader = lastReader[0]))).scorer(previousReader, true, false)) != null) {
                    boolean more = scorer.advance(lastDoc[0] + 1) != Integer.MAX_VALUE;
                    Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but skipTo(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
                }
                this.reader = lastReader[0] = reader;
                lastDoc[0] = -1;
            }

            public boolean acceptsDocsOutOfOrder() {
                return false;
            }
        });
        if (lastReader[0] != null && (scorer = (w = q.weight((Searcher)new IndexSearcher(previousReader = lastReader[0]))).scorer(previousReader, true, false)) != null) {
            boolean more = scorer.advance(lastDoc[0] + 1) != Integer.MAX_VALUE;
            Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but skipTo(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
        }
    }
}

