/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.web;

import java.security.Principal;
import java.util.Objects;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.lookup.AbstractLookup;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.util.Strings;
import org.apache.logging.log4j.web.Log4jServletFilter;
import org.apache.logging.log4j.web.WebLoggerContextUtils;

@Namespace(value="Lookup")
@Plugin(value="web")
public class WebLookup
extends AbstractLookup {
    private static final String SESSION_ATTR_PREFIX = "session.attr.";
    private static final String REQUEST_ATTR_PREFIX = "request.attr.";
    private static final String REQUEST_HEADER_PREFIX = "header.";
    private static final String REQUEST_COOKIE_PREFIX = "cookie.";
    private static final String REQUEST_PARAMETER_PREFIX = "request.parameter.";
    private static final String ATTR_PREFIX = "attr.";
    private static final String INIT_PARAM_PREFIX = "initParam.";

    public String lookup(LogEvent event, String key) {
        ServletContext ctx = WebLoggerContextUtils.getServletContext();
        if (ctx == null) {
            return null;
        }
        if (key.startsWith(ATTR_PREFIX)) {
            String attrName = key.substring(ATTR_PREFIX.length());
            Object attrValue = ctx.getAttribute(attrName);
            return attrValue == null ? null : attrValue.toString();
        }
        if (key.startsWith(INIT_PARAM_PREFIX)) {
            String paramName = key.substring(INIT_PARAM_PREFIX.length());
            return ctx.getInitParameter(paramName);
        }
        if (key.startsWith(REQUEST_ATTR_PREFIX)) {
            String name = key.substring(REQUEST_ATTR_PREFIX.length());
            ServletRequest req = this.getRequest();
            Object value = req == null ? null : req.getAttribute(name);
            return value == null ? null : String.valueOf(value);
        }
        if (key.startsWith(REQUEST_HEADER_PREFIX)) {
            String name = key.substring(REQUEST_HEADER_PREFIX.length());
            ServletRequest req = this.getRequest();
            return HttpServletRequest.class.isInstance(req) ? ((HttpServletRequest)HttpServletRequest.class.cast(req)).getHeader(name) : null;
        }
        if (key.startsWith(REQUEST_COOKIE_PREFIX)) {
            String name = key.substring(REQUEST_COOKIE_PREFIX.length());
            ServletRequest req = this.getRequest();
            return HttpServletRequest.class.isInstance(req) ? (String)Stream.of(((HttpServletRequest)HttpServletRequest.class.cast(req)).getCookies()).filter(c -> name.equals(c.getName())).findFirst().map(Cookie::getValue).orElse(null) : null;
        }
        if (key.startsWith(REQUEST_PARAMETER_PREFIX)) {
            String name = key.substring(REQUEST_PARAMETER_PREFIX.length());
            ServletRequest req = this.getRequest();
            return HttpServletRequest.class.isInstance(req) ? ((HttpServletRequest)HttpServletRequest.class.cast(req)).getParameter(name) : null;
        }
        if (key.startsWith(SESSION_ATTR_PREFIX)) {
            HttpSession session;
            ServletRequest req = this.getRequest();
            if (HttpServletRequest.class.isInstance(req) && (session = ((HttpServletRequest)HttpServletRequest.class.cast(req)).getSession(false)) != null) {
                String name = key.substring(SESSION_ATTR_PREFIX.length());
                return Objects.toString(session.getAttribute(name), null);
            }
            return null;
        }
        if ("request.method".equals(key)) {
            ServletRequest req = this.getRequest();
            return HttpServletRequest.class.isInstance(req) ? ((HttpServletRequest)HttpServletRequest.class.cast(req)).getMethod() : null;
        }
        if ("request.uri".equals(key)) {
            ServletRequest req = this.getRequest();
            return HttpServletRequest.class.isInstance(req) ? ((HttpServletRequest)HttpServletRequest.class.cast(req)).getRequestURI() : null;
        }
        if ("request.url".equals(key)) {
            ServletRequest req = this.getRequest();
            return HttpServletRequest.class.isInstance(req) ? ((HttpServletRequest)HttpServletRequest.class.cast(req)).getRequestURL().toString() : null;
        }
        if ("request.remoteAddress".equals(key)) {
            ServletRequest req = this.getRequest();
            return HttpServletRequest.class.isInstance(req) ? ((HttpServletRequest)HttpServletRequest.class.cast(req)).getRemoteAddr() : null;
        }
        if ("request.remoteHost".equals(key)) {
            ServletRequest req = this.getRequest();
            return HttpServletRequest.class.isInstance(req) ? ((HttpServletRequest)HttpServletRequest.class.cast(req)).getRemoteHost() : null;
        }
        if ("request.remotePort".equals(key)) {
            ServletRequest req = this.getRequest();
            return HttpServletRequest.class.isInstance(req) ? Integer.toString(((HttpServletRequest)HttpServletRequest.class.cast(req)).getRemotePort()) : null;
        }
        if ("request.principal".equals(key)) {
            ServletRequest req = this.getRequest();
            Principal pcp = HttpServletRequest.class.isInstance(req) ? ((HttpServletRequest)HttpServletRequest.class.cast(req)).getUserPrincipal() : null;
            return pcp == null ? null : pcp.getName();
        }
        if ("session.id".equals(key)) {
            ServletRequest req = this.getRequest();
            HttpSession session = HttpServletRequest.class.isInstance(req) ? ((HttpServletRequest)HttpServletRequest.class.cast(req)).getSession(false) : null;
            return session == null ? null : session.getId();
        }
        if ("rootDir".equals(key)) {
            String root = ctx.getRealPath("/");
            if (root == null) {
                String msg = "Failed to resolve web:rootDir -- servlet container unable to translate virtual path  to real path (probably not deployed as exploded";
                throw new IllegalStateException("Failed to resolve web:rootDir -- servlet container unable to translate virtual path  to real path (probably not deployed as exploded");
            }
            return root;
        }
        if ("contextPathName".equals(key)) {
            String path = ctx.getContextPath();
            if (path.trim().contains("/")) {
                String[] fields;
                for (String field : fields = path.split("/")) {
                    if (field.length() <= 0) continue;
                    return field;
                }
                return null;
            }
            return ctx.getContextPath();
        }
        if ("contextPath".equals(key)) {
            return ctx.getContextPath();
        }
        if ("servletContextName".equals(key)) {
            return ctx.getServletContextName();
        }
        if ("serverInfo".equals(key)) {
            return ctx.getServerInfo();
        }
        if ("effectiveMajorVersion".equals(key)) {
            return String.valueOf(ctx.getEffectiveMajorVersion());
        }
        if ("effectiveMinorVersion".equals(key)) {
            return String.valueOf(ctx.getEffectiveMinorVersion());
        }
        if ("majorVersion".equals(key)) {
            return String.valueOf(ctx.getMajorVersion());
        }
        if ("minorVersion".equals(key)) {
            return String.valueOf(ctx.getMinorVersion());
        }
        if (ctx.getAttribute(key) != null) {
            return ctx.getAttribute(key).toString();
        }
        if (ctx.getInitParameter(key) != null) {
            return ctx.getInitParameter(key);
        }
        ctx.log(((Object)((Object)this)).getClass().getName() + " unable to resolve key " + Strings.quote((String)key));
        return null;
    }

    private ServletRequest getRequest() {
        ServletRequest servletRequest = Log4jServletFilter.CURRENT_REQUEST.get();
        if (servletRequest == null) {
            Log4jServletFilter.CURRENT_REQUEST.remove();
        }
        return servletRequest;
    }
}

