/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.tojul;

import java.util.Objects;
import java.util.logging.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.tojul.LazyLog4jLogRecord;

final class JULLogger
extends AbstractLogger {
    private static final long serialVersionUID = 1L;
    private final Logger logger;

    public JULLogger(String name, MessageFactory messageFactory, Logger logger) {
        super(name, messageFactory);
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    public JULLogger(String name, Logger logger) {
        super(name);
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    public Logger getWrappedLogger() {
        return this.logger;
    }

    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        java.util.logging.Level julLevel = this.convertLevel(level);
        if (!this.logger.isLoggable(julLevel)) {
            return;
        }
        LazyLog4jLogRecord record = new LazyLog4jLogRecord(fqcn, julLevel, message.getFormattedMessage());
        record.setLoggerName(this.getName());
        record.setThrown(t == null ? message.getThrowable() : t);
        this.logger.log(record);
    }

    private java.util.logging.Level convertLevel(Level level) {
        switch (level.getStandardLevel()) {
            case ALL: {
                return java.util.logging.Level.ALL;
            }
            case TRACE: {
                return java.util.logging.Level.FINER;
            }
            case DEBUG: {
                return java.util.logging.Level.FINE;
            }
            case INFO: {
                return java.util.logging.Level.INFO;
            }
            case WARN: {
                return java.util.logging.Level.WARNING;
            }
            case ERROR: {
                return java.util.logging.Level.SEVERE;
            }
            case FATAL: {
                return java.util.logging.Level.SEVERE;
            }
            case OFF: {
                return java.util.logging.Level.OFF;
            }
        }
        return java.util.logging.Level.SEVERE;
    }

    public Level getLevel() {
        int julLevel = this.getEffectiveJULLevel().intValue();
        if (julLevel == java.util.logging.Level.ALL.intValue()) {
            return Level.ALL;
        }
        if (julLevel <= java.util.logging.Level.FINER.intValue()) {
            return Level.TRACE;
        }
        if (julLevel <= java.util.logging.Level.FINE.intValue()) {
            return Level.DEBUG;
        }
        if (julLevel <= java.util.logging.Level.INFO.intValue()) {
            return Level.INFO;
        }
        if (julLevel <= java.util.logging.Level.WARNING.intValue()) {
            return Level.WARN;
        }
        if (julLevel <= java.util.logging.Level.SEVERE.intValue()) {
            return Level.ERROR;
        }
        return Level.OFF;
    }

    private java.util.logging.Level getEffectiveJULLevel() {
        Logger current = this.logger;
        while (current.getLevel() == null && current.getParent() != null) {
            current = current.getParent();
        }
        if (current.getLevel() != null) {
            return current.getLevel();
        }
        return Logger.getGlobal().getLevel();
    }

    private boolean isEnabledFor(Level level, Marker marker) {
        return this.getLevel().isLessSpecificThan(level);
    }

    public boolean isEnabled(Level level, Marker marker, Message data, Throwable t) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, CharSequence data, Throwable t) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, Object data, Throwable t) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, String data) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, String data, Object ... p1) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.isEnabledFor(level, marker);
    }

    public boolean isEnabled(Level level, Marker marker, String data, Throwable t) {
        return this.isEnabledFor(level, marker);
    }
}

