/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.slf4j.Log4jLoggerFactory;
import org.apache.logging.slf4j.Log4jMarker;
import org.apache.logging.slf4j.Log4jMarkerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.IMarkerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class MarkerTest {
    private static final String CHILD_MAKER_NAME = MarkerTest.class.getSimpleName() + "-TEST";
    private static final String PARENT_MARKER_NAME = MarkerTest.class.getSimpleName() + "-PARENT";
    private static Log4jMarkerFactory markerFactory;

    @BeforeClass
    public static void startup() {
        markerFactory = ((Log4jLoggerFactory)LoggerFactory.getILoggerFactory()).getMarkerFactory();
    }

    @Before
    @After
    public void clearMarkers() {
        MarkerManager.clear();
    }

    @Test
    public void testAddMarker() {
        String childMakerName = CHILD_MAKER_NAME + "-AM";
        String parentMarkerName = PARENT_MARKER_NAME + "-AM";
        Marker slf4jMarker = MarkerFactory.getMarker((String)childMakerName);
        Marker slf4jParent = MarkerFactory.getMarker((String)parentMarkerName);
        slf4jMarker.add(slf4jParent);
        org.apache.logging.log4j.Marker log4jParent = MarkerManager.getMarker((String)parentMarkerName);
        org.apache.logging.log4j.Marker log4jMarker = MarkerManager.getMarker((String)childMakerName);
        Assert.assertTrue((String)"Incorrect Marker class", (boolean)(slf4jMarker instanceof Log4jMarker));
        Assert.assertTrue((String)String.format("%s (log4jMarker=%s) is not an instance of %s (log4jParent=%s) in Log4j", childMakerName, parentMarkerName, log4jMarker, log4jParent), (boolean)log4jMarker.isInstanceOf(log4jParent));
        Assert.assertTrue((String)String.format("%s (slf4jMarker=%s) is not an instance of %s (log4jParent=%s) in SLF4J", childMakerName, parentMarkerName, slf4jMarker, slf4jParent), (boolean)slf4jMarker.contains(slf4jParent));
    }

    @Test
    public void testAddNullMarker() {
        String childMarkerName = CHILD_MAKER_NAME + "-ANM";
        String parentMakerName = PARENT_MARKER_NAME + "-ANM";
        Marker slf4jMarker = MarkerFactory.getMarker((String)childMarkerName);
        Marker slf4jParent = MarkerFactory.getMarker((String)parentMakerName);
        slf4jMarker.add(slf4jParent);
        org.apache.logging.log4j.Marker log4jParent = MarkerManager.getMarker((String)parentMakerName);
        org.apache.logging.log4j.Marker log4jMarker = MarkerManager.getMarker((String)childMarkerName);
        Log4jMarker log4jSlf4jParent = new Log4jMarker((IMarkerFactory)markerFactory, log4jParent);
        Log4jMarker log4jSlf4jMarker = new Log4jMarker((IMarkerFactory)markerFactory, log4jMarker);
        Marker nullMarker = null;
        try {
            log4jSlf4jParent.add(nullMarker);
            Assert.fail((String)("Expected " + IllegalArgumentException.class.getName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            log4jSlf4jMarker.add(nullMarker);
            Assert.fail((String)("Expected " + IllegalArgumentException.class.getName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddSameMarker() {
        String childMarkerName = CHILD_MAKER_NAME + "-ASM";
        String parentMakerName = PARENT_MARKER_NAME + "-ASM";
        Marker slf4jMarker = MarkerFactory.getMarker((String)childMarkerName);
        Marker slf4jParent = MarkerFactory.getMarker((String)parentMakerName);
        slf4jMarker.add(slf4jParent);
        slf4jMarker.add(slf4jParent);
        org.apache.logging.log4j.Marker log4jParent = MarkerManager.getMarker((String)parentMakerName);
        org.apache.logging.log4j.Marker log4jMarker = MarkerManager.getMarker((String)childMarkerName);
        Assert.assertTrue((String)String.format("%s (log4jMarker=%s) is not an instance of %s (log4jParent=%s) in Log4j", childMarkerName, parentMakerName, log4jMarker, log4jParent), (boolean)log4jMarker.isInstanceOf(log4jParent));
        Assert.assertTrue((String)String.format("%s (slf4jMarker=%s) is not an instance of %s (log4jParent=%s) in SLF4J", childMarkerName, parentMakerName, slf4jMarker, slf4jParent), (boolean)slf4jMarker.contains(slf4jParent));
    }

    @Test
    public void testEquals() {
        String childMarkerName = CHILD_MAKER_NAME + "-ASM";
        String parentMakerName = PARENT_MARKER_NAME + "-ASM";
        Marker slf4jMarker = MarkerFactory.getMarker((String)childMarkerName);
        Marker slf4jMarker2 = MarkerFactory.getMarker((String)childMarkerName);
        Marker slf4jParent = MarkerFactory.getMarker((String)parentMakerName);
        slf4jMarker.add(slf4jParent);
        org.apache.logging.log4j.Marker log4jParent = MarkerManager.getMarker((String)parentMakerName);
        org.apache.logging.log4j.Marker log4jMarker = MarkerManager.getMarker((String)childMarkerName);
        org.apache.logging.log4j.Marker log4jMarker2 = MarkerManager.getMarker((String)childMarkerName);
        Assert.assertEquals((Object)log4jParent, (Object)log4jParent);
        Assert.assertEquals((Object)log4jMarker, (Object)log4jMarker);
        Assert.assertEquals((Object)log4jMarker, (Object)log4jMarker2);
        Assert.assertEquals((Object)slf4jMarker, (Object)slf4jMarker2);
        Assert.assertNotEquals((Object)log4jParent, (Object)log4jMarker);
        Assert.assertNotEquals((Object)log4jMarker, (Object)log4jParent);
    }

    @Test
    public void testContainsNullMarker() {
        String childMarkerName = CHILD_MAKER_NAME + "-CM";
        String parentMakerName = PARENT_MARKER_NAME + "-CM";
        Marker slf4jMarker = MarkerFactory.getMarker((String)childMarkerName);
        Marker slf4jParent = MarkerFactory.getMarker((String)parentMakerName);
        slf4jMarker.add(slf4jParent);
        org.apache.logging.log4j.Marker log4jParent = MarkerManager.getMarker((String)parentMakerName);
        org.apache.logging.log4j.Marker log4jMarker = MarkerManager.getMarker((String)childMarkerName);
        Log4jMarker log4jSlf4jParent = new Log4jMarker((IMarkerFactory)markerFactory, log4jParent);
        Log4jMarker log4jSlf4jMarker = new Log4jMarker((IMarkerFactory)markerFactory, log4jMarker);
        Marker nullMarker = null;
        try {
            Assert.assertFalse((boolean)log4jSlf4jParent.contains(nullMarker));
            Assert.fail((String)("Expected " + IllegalArgumentException.class.getName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)log4jSlf4jMarker.contains(nullMarker));
            Assert.fail((String)("Expected " + IllegalArgumentException.class.getName()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testContainsNullString() {
        String childMarkerName = CHILD_MAKER_NAME + "-CS";
        String parentMakerName = PARENT_MARKER_NAME + "-CS";
        Marker slf4jMarker = MarkerFactory.getMarker((String)childMarkerName);
        Marker slf4jParent = MarkerFactory.getMarker((String)parentMakerName);
        slf4jMarker.add(slf4jParent);
        org.apache.logging.log4j.Marker log4jParent = MarkerManager.getMarker((String)parentMakerName);
        org.apache.logging.log4j.Marker log4jMarker = MarkerManager.getMarker((String)childMarkerName);
        Log4jMarker log4jSlf4jParent = new Log4jMarker((IMarkerFactory)markerFactory, log4jParent);
        Log4jMarker log4jSlf4jMarker = new Log4jMarker((IMarkerFactory)markerFactory, log4jMarker);
        String nullStr = null;
        Assert.assertFalse((boolean)log4jSlf4jParent.contains(nullStr));
        Assert.assertFalse((boolean)log4jSlf4jMarker.contains(nullStr));
    }

    @Test
    public void testRemoveNullMarker() {
        String childMakerName = CHILD_MAKER_NAME + "-CM";
        String parentMakerName = PARENT_MARKER_NAME + "-CM";
        Marker slf4jMarker = MarkerFactory.getMarker((String)childMakerName);
        Marker slf4jParent = MarkerFactory.getMarker((String)parentMakerName);
        slf4jMarker.add(slf4jParent);
        org.apache.logging.log4j.Marker log4jParent = MarkerManager.getMarker((String)parentMakerName);
        org.apache.logging.log4j.Marker log4jMarker = MarkerManager.getMarker((String)childMakerName);
        Log4jMarker log4jSlf4jParent = new Log4jMarker((IMarkerFactory)markerFactory, log4jParent);
        Log4jMarker log4jSlf4jMarker = new Log4jMarker((IMarkerFactory)markerFactory, log4jMarker);
        Marker nullMarker = null;
        Assert.assertFalse((boolean)log4jSlf4jParent.remove(nullMarker));
        Assert.assertFalse((boolean)log4jSlf4jMarker.remove(nullMarker));
    }
}

