/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.Strings;
import org.apache.logging.slf4j.CustomFlatMarker;
import org.apache.logging.slf4j.Log4jLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.ext.EventData;
import org.slf4j.ext.EventLogger;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class LoggerTest {
    private static final String CONFIG = "log4j-test1.xml";
    @ClassRule
    public static LoggerContextRule ctx = new LoggerContextRule("log4j-test1.xml");
    Logger logger = LoggerFactory.getLogger((String)"LoggerTest");
    XLogger xlogger = XLoggerFactory.getXLogger((String)"LoggerTest");

    @Test
    public void basicFlow() {
        this.xlogger.entry(new Object[0]);
        this.verify("List", "o.a.l.s.LoggerTest entry MDC{}" + Strings.LINE_SEPARATOR);
        this.xlogger.exit();
        this.verify("List", "o.a.l.s.LoggerTest exit MDC{}" + Strings.LINE_SEPARATOR);
    }

    @Test
    public void simpleFlow() {
        this.xlogger.entry(new Object[]{CONFIG});
        this.verify("List", "o.a.l.s.LoggerTest entry with (log4j-test1.xml) MDC{}" + Strings.LINE_SEPARATOR);
        this.xlogger.exit((Object)0);
        this.verify("List", "o.a.l.s.LoggerTest exit with (0) MDC{}" + Strings.LINE_SEPARATOR);
    }

    @Test
    public void throwing() {
        this.xlogger.throwing((Throwable)new IllegalArgumentException("Test Exception"));
        this.verify("List", "o.a.l.s.LoggerTest throwing MDC{}" + Strings.LINE_SEPARATOR);
    }

    @Test
    public void catching() {
        try {
            throw new NullPointerException();
        }
        catch (Exception e) {
            this.xlogger.catching((Throwable)e);
            this.verify("List", "o.a.l.s.LoggerTest catching MDC{}" + Strings.LINE_SEPARATOR);
            return;
        }
    }

    @Test
    public void debug() {
        this.logger.debug("Debug message");
        this.verify("List", "o.a.l.s.LoggerTest Debug message MDC{}" + Strings.LINE_SEPARATOR);
    }

    @Test
    public void debugNoParms() {
        this.logger.debug("Debug message {}");
        this.verify("List", "o.a.l.s.LoggerTest Debug message {} MDC{}" + Strings.LINE_SEPARATOR);
        this.logger.debug("Debug message {}", (Object[])null);
        this.verify("List", "o.a.l.s.LoggerTest Debug message {} MDC{}" + Strings.LINE_SEPARATOR);
        ((LocationAwareLogger)this.logger).log(null, Log4jLogger.class.getName(), 10, "Debug message {}", null, null);
        this.verify("List", "o.a.l.s.LoggerTest Debug message {} MDC{}" + Strings.LINE_SEPARATOR);
    }

    @Test
    public void debugWithParms() {
        this.logger.debug("Hello, {}", (Object)"World");
        this.verify("List", "o.a.l.s.LoggerTest Hello, World MDC{}" + Strings.LINE_SEPARATOR);
    }

    @Test
    public void mdc() {
        MDC.put((String)"TestYear", (String)"2010");
        this.logger.debug("Debug message");
        this.verify("List", "o.a.l.s.LoggerTest Debug message MDC{TestYear=2010}" + Strings.LINE_SEPARATOR);
        MDC.clear();
        this.logger.debug("Debug message");
        this.verify("List", "o.a.l.s.LoggerTest Debug message MDC{}" + Strings.LINE_SEPARATOR);
    }

    @Test
    public void supportsCustomSLF4JMarkers() {
        CustomFlatMarker marker = new CustomFlatMarker("TEST");
        this.logger.debug((Marker)marker, "Test");
        this.verify("List", "o.a.l.s.LoggerTest Test MDC{}" + Strings.LINE_SEPARATOR);
    }

    @Test
    public void testRootLogger() {
        Logger l = LoggerFactory.getLogger((String)"ROOT");
        Assert.assertNotNull((String)"No Root Logger", (Object)l);
        Assert.assertEquals((Object)"ROOT", (Object)l.getName());
    }

    @Test
    public void doubleSubst() {
        this.logger.debug("Hello, {}", (Object)"Log4j {}");
        this.verify("List", "o.a.l.s.LoggerTest Hello, Log4j {} MDC{}" + Strings.LINE_SEPARATOR);
        this.xlogger.debug("Hello, {}", (Object)"Log4j {}");
        this.verify("List", "o.a.l.s.LoggerTest Hello, Log4j Log4j {} MDC{}" + Strings.LINE_SEPARATOR);
    }

    @Test
    public void testEventLogger() {
        MDC.put((String)"loginId", (String)"JohnDoe");
        MDC.put((String)"ipAddress", (String)"192.168.0.120");
        MDC.put((String)"locale", (String)Locale.US.getDisplayName());
        EventData data = new EventData();
        data.setEventType("Transfer");
        data.setEventId("Audit@18060");
        data.setMessage("Transfer Complete");
        data.put("ToAccount", (Serializable)((Object)"123456"));
        data.put("FromAccount", (Serializable)((Object)"123457"));
        data.put("Amount", (Serializable)((Object)"200.00"));
        EventLogger.logEvent((EventData)data);
        MDC.clear();
        this.verify("EventLogger", "o.a.l.s.LoggerTest Transfer [Audit@18060 Amount=\"200.00\" FromAccount=\"123457\" ToAccount=\"123456\"] Transfer Complete" + Strings.LINE_SEPARATOR);
    }

    private void verify(String name, String expected) {
        ListAppender listApp = ctx.getListAppender(name);
        Assert.assertNotNull((String)"Missing Appender", (Object)listApp);
        List events = listApp.getMessages();
        Assert.assertTrue((String)("Incorrect number of messages. Expected 1 Actual " + events.size()), (events.size() == 1 ? 1 : 0) != 0);
        String actual = (String)events.get(0);
        Assert.assertEquals((String)("Incorrect message. Expected " + expected + ". Actual " + actual), (Object)expected, (Object)actual);
        listApp.clear();
    }

    @Before
    @After
    public void cleanup() {
        MDC.clear();
        ctx.getListAppender("List").clear();
        ctx.getListAppender("EventLogger").clear();
    }
}

