/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.util.List;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallerInformationTest {
    private static final String CONFIG = "log4j2-calling-class.xml";
    @ClassRule
    public static final LoggerContextRule ctx = new LoggerContextRule("log4j2-calling-class.xml");

    @Test
    public void testClassLogger() throws Exception {
        ListAppender app = ctx.getListAppender("Class").clear();
        Logger logger = LoggerFactory.getLogger((String)"ClassLogger");
        logger.info("Ignored message contents.");
        logger.warn("Verifying the caller class is still correct.");
        logger.error("Hopefully nobody breaks me!");
        List messages = app.getMessages();
        Assert.assertEquals((String)"Incorrect number of messages.", (long)3L, (long)messages.size());
        for (String message : messages) {
            Assert.assertEquals((String)"Incorrect caller class name.", (Object)this.getClass().getName(), (Object)message);
        }
    }

    @Test
    public void testMethodLogger() throws Exception {
        ListAppender app = ctx.getListAppender("Method").clear();
        Logger logger = LoggerFactory.getLogger((String)"MethodLogger");
        logger.info("More messages.");
        logger.warn("CATASTROPHE INCOMING!");
        logger.error("ZOMBIES!!!");
        logger.warn("brains~~~");
        logger.info("Itchy. Tasty.");
        List messages = app.getMessages();
        Assert.assertEquals((String)"Incorrect number of messages.", (long)5L, (long)messages.size());
        for (String message : messages) {
            Assert.assertEquals((String)"Incorrect caller method name.", (Object)"testMethodLogger", (Object)message);
        }
    }
}

