/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.util.List;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.Strings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class OptionalTest {
    private static final String CONFIG = "log4j-test1.xml";
    @ClassRule
    public static final LoggerContextRule CTX = new LoggerContextRule("log4j-test1.xml");
    Logger logger = LoggerFactory.getLogger((String)"EventLogger");
    Marker marker = MarkerFactory.getMarker((String)"EVENT");

    @Test
    public void testEventLogger() {
        this.logger.info(this.marker, "This is a test");
        MDC.clear();
        this.verify("EventLogger", "o.a.l.s.OptionalTest This is a test" + Strings.LINE_SEPARATOR);
    }

    private void verify(String name, String expected) {
        ListAppender listApp = CTX.getListAppender(name);
        List events = listApp.getMessages();
        Assert.assertTrue((String)("Incorrect number of messages. Expected 1 Actual " + events.size()), (events.size() == 1 ? 1 : 0) != 0);
        String actual = (String)events.get(0);
        Assert.assertEquals((String)("Incorrect message. Expected " + expected + ". Actual " + actual), (Object)expected, (Object)actual);
        listApp.clear();
    }

    @Before
    public void cleanup() {
        CTX.getListAppender("List").clear();
        CTX.getListAppender("EventLogger").clear();
    }
}

