/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.script.filter;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.script.Script;
import org.apache.logging.log4j.core.script.ScriptBindings;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.script.ScriptManagerImpl;
import org.apache.logging.log4j.script.ScriptRef;
import org.apache.logging.log4j.status.StatusLogger;

@Configurable(elementType="filter", printObject=true)
@Plugin
public final class ScriptFilter
extends AbstractFilter {
    private static final Logger logger = StatusLogger.getLogger();
    private final Script script;
    private final Configuration configuration;

    private ScriptFilter(Script script, Configuration configuration, Filter.Result onMatch, Filter.Result onMismatch) {
        super(onMatch, onMismatch);
        this.script = script;
        this.configuration = configuration;
    }

    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String msg, Object ... params) {
        ScriptBindings bindings = ScriptManagerImpl.createBindings();
        bindings.put((Object)"logger", (Object)logger);
        bindings.put((Object)"level", (Object)level);
        bindings.put((Object)"marker", (Object)marker);
        bindings.put((Object)"message", (Object)new SimpleMessage(msg));
        bindings.put((Object)"parameters", (Object)params);
        bindings.put((Object)"throwable", null);
        bindings.putAll(this.configuration.getProperties());
        bindings.put((Object)"substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), bindings);
        return !Boolean.TRUE.equals(object) ? this.onMismatch : this.onMatch;
    }

    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        ScriptBindings bindings = ScriptManagerImpl.createBindings();
        bindings.put((Object)"logger", (Object)logger);
        bindings.put((Object)"level", (Object)level);
        bindings.put((Object)"marker", (Object)marker);
        bindings.put((Object)"message", msg instanceof String ? new SimpleMessage((String)msg) : new ObjectMessage(msg));
        bindings.put((Object)"parameters", null);
        bindings.put((Object)"throwable", (Object)t);
        bindings.putAll(this.configuration.getProperties());
        bindings.put((Object)"substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), bindings);
        return object == null || !Boolean.TRUE.equals(object) ? this.onMismatch : this.onMatch;
    }

    public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        ScriptBindings bindings = ScriptManagerImpl.createBindings();
        bindings.put((Object)"logger", (Object)logger);
        bindings.put((Object)"level", (Object)level);
        bindings.put((Object)"marker", (Object)marker);
        bindings.put((Object)"message", (Object)msg);
        bindings.put((Object)"parameters", null);
        bindings.put((Object)"throwable", (Object)t);
        bindings.putAll(this.configuration.getProperties());
        bindings.put((Object)"substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), bindings);
        return object == null || !Boolean.TRUE.equals(object) ? this.onMismatch : this.onMatch;
    }

    public Filter.Result filter(LogEvent event) {
        ScriptBindings bindings = ScriptManagerImpl.createBindings();
        bindings.put((Object)"logEvent", (Object)event);
        bindings.putAll(this.configuration.getProperties());
        bindings.put((Object)"substitutor", (Object)this.configuration.getStrSubstitutor());
        Object object = this.configuration.getScriptManager().execute(this.script.getName(), bindings);
        return object == null || !Boolean.TRUE.equals(object) ? this.onMismatch : this.onMatch;
    }

    public String toString() {
        return this.script.getName();
    }

    @PluginFactory
    public static ScriptFilter createFilter(@PluginElement Script script, @PluginAttribute Filter.Result onMatch, @PluginAttribute Filter.Result onMismatch, @PluginConfiguration Configuration configuration) {
        if (script == null) {
            AbstractLifeCycle.LOGGER.error("A Script, ScriptFile or ScriptRef element must be provided for this ScriptFilter");
            return null;
        }
        if (configuration.getScriptManager() == null) {
            LOGGER.error("Script support is not enabled");
            return null;
        }
        if (script instanceof ScriptRef) {
            if (configuration.getScriptManager().getScript(script.getName()) == null) {
                logger.error("No script with name {} has been declared.", (Object)script.getName());
                return null;
            }
        } else if (!configuration.getScriptManager().addScript(script)) {
            return null;
        }
        return new ScriptFilter(script, configuration, onMatch, onMismatch);
    }
}

