/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.script.factory;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.script.ScriptManager;
import org.apache.logging.log4j.core.script.ScriptManagerFactory;
import org.apache.logging.log4j.core.util.WatchManager;
import org.apache.logging.log4j.script.ScriptManagerImpl;
import org.apache.logging.log4j.script.ScriptPropertyKey;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertyKey;

public class ScriptManagerFactoryImpl
implements ScriptManagerFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();

    public ScriptManager createScriptManager(Configuration configuration, WatchManager watchManager) {
        String scriptLanguages = PropertiesUtil.getProperties().getStringProperty((PropertyKey)ScriptPropertyKey.SCRIPT_ENABLE_LANGUAGES);
        if (scriptLanguages != null) {
            try {
                return new ScriptManagerImpl(configuration, watchManager);
            }
            catch (Exception | LinkageError e) {
                LOGGER.info("Cannot initialize scripting support because this JRE does not support it.", e);
            }
        }
        return null;
    }
}

