/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.FactoryType;
import org.apache.logging.log4j.plugins.ScopeType;
import org.apache.logging.log4j.plugins.condition.Condition;
import org.apache.logging.log4j.plugins.condition.ConditionContext;
import org.apache.logging.log4j.plugins.condition.Conditional;
import org.apache.logging.log4j.plugins.di.Binding;
import org.apache.logging.log4j.plugins.di.CircularDependencyException;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.plugins.di.DuplicateBindingException;
import org.apache.logging.log4j.plugins.di.InstanceFactory;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.Keys;
import org.apache.logging.log4j.plugins.di.NoQualifiedBindingException;
import org.apache.logging.log4j.plugins.di.NotInjectableException;
import org.apache.logging.log4j.plugins.di.spi.DependencyChain;
import org.apache.logging.log4j.plugins.di.spi.FactoryResolver;
import org.apache.logging.log4j.plugins.di.spi.InjectionPoint;
import org.apache.logging.log4j.plugins.di.spi.InstancePostProcessor;
import org.apache.logging.log4j.plugins.di.spi.ReflectionAgent;
import org.apache.logging.log4j.plugins.di.spi.ResolvableKey;
import org.apache.logging.log4j.plugins.di.spi.Scope;
import org.apache.logging.log4j.plugins.internal.util.BeanUtils;
import org.apache.logging.log4j.plugins.internal.util.BindingMap;
import org.apache.logging.log4j.plugins.internal.util.HierarchicalMap;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.plugins.util.OrderedComparator;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertyEnvironment;

public class DefaultInstanceFactory
implements ConfigurableInstanceFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final ThreadLocal<InjectionPoint<?>> currentInjectionPoint = new ThreadLocal();
    private final BindingMap bindings;
    private final HierarchicalMap<Class<? extends Annotation>, Scope> scopes;
    private final List<FactoryResolver<?>> factoryResolvers;
    private final SortedSet<InstancePostProcessor> instancePostProcessors = new ConcurrentSkipListSet<InstancePostProcessor>(Comparator.comparing(Object::getClass, OrderedComparator.INSTANCE));
    private ReflectionAgent agent = object -> object.setAccessible(true);

    protected DefaultInstanceFactory() {
        this(BindingMap.newRootMap(), HierarchicalMap.newRootMap(), new ArrayList(), List.of());
    }

    protected DefaultInstanceFactory(DefaultInstanceFactory parent) {
        this(parent.bindings.newChildMap(), parent.scopes.newChildMap(), parent.factoryResolvers, parent.instancePostProcessors);
        this.agent = parent.agent;
    }

    private DefaultInstanceFactory(BindingMap bindings, HierarchicalMap<Class<? extends Annotation>, Scope> scopes, List<FactoryResolver<?>> factoryResolvers, Collection<InstancePostProcessor> instancePostProcessors) {
        this.bindings = bindings;
        this.scopes = scopes;
        this.factoryResolvers = factoryResolvers;
        this.instancePostProcessors.addAll(instancePostProcessors);
        this.bindings.put(Binding.from(InjectionPoint.CURRENT_INJECTION_POINT).to(this.currentInjectionPoint::get));
        this.bindings.put(Binding.from(ConfigurableInstanceFactory.class).toInstance(this));
        this.bindings.put(Binding.from(InstanceFactory.class).toInstance(this));
        this.bindings.put(Binding.from(PropertyEnvironment.class).to(PropertiesUtil::getProperties));
        this.bindings.put(Binding.from(ClassLoader.class).to(LoaderUtil::getClassLoader));
    }

    @Override
    public <T> Supplier<T> getFactory(ResolvableKey<T> resolvableKey) {
        Key<T> key = resolvableKey.getKey();
        Binding<T> existingBinding = this.bindings.get(key, resolvableKey.getAliases());
        if (existingBinding != null) {
            return existingBinding;
        }
        Supplier unscoped = this.resolveKey(resolvableKey).orElseGet(() -> this.createDefaultFactory(resolvableKey));
        Scope scope = this.getScopeForType(key.getRawType());
        Supplier<T> scoped = scope.get(key, unscoped);
        Binding<T> binding = Binding.from(key).to(scoped);
        this.registerBinding(binding);
        return binding;
    }

    protected <T> Optional<Supplier<T>> resolveKey(ResolvableKey<T> resolvableKey) {
        return this.factoryResolvers.stream().filter(resolver -> resolver.supportsKey(resolvableKey.getKey())).findFirst().map(Cast::cast).map(resolver -> resolver.getFactory(resolvableKey, this));
    }

    protected <T> Supplier<T> createDefaultFactory(ResolvableKey<T> resolvableKey) {
        Key key = resolvableKey.getKey();
        if (key.getQualifierType() != null) {
            throw new NoQualifiedBindingException(resolvableKey);
        }
        if (!BeanUtils.isInjectable(key.getRawType())) {
            throw new NotInjectableException(resolvableKey);
        }
        return () -> {
            Object instance = this.getInjectableInstance(resolvableKey);
            instance = this.postProcessBeforeInitialization(resolvableKey, instance);
            this.injectMembers(key, instance, resolvableKey.getDependencyChain());
            instance = this.postProcessAfterInitialization(resolvableKey, instance);
            if (instance instanceof Supplier) {
                Supplier supplier = (Supplier)Cast.cast(instance);
                instance = supplier.get();
            }
            return instance;
        };
    }

    protected <T> T getInjectableInstance(ResolvableKey<T> resolvableKey) {
        Class<T> rawType = resolvableKey.getRawType();
        this.validate(rawType, resolvableKey.getName(), rawType);
        Executable factory = BeanUtils.getInjectableFactory(resolvableKey);
        Key<T> key = resolvableKey.getKey();
        DependencyChain updatedChain = resolvableKey.getDependencyChain().withDependency(key);
        Object[] arguments = InjectionPoint.fromExecutable(factory).stream().map(point -> this.getArgumentFactory((InjectionPoint)point, updatedChain).get()).toArray();
        return this.invokeFactory(factory, arguments);
    }

    protected <T> T postProcessBeforeInitialization(ResolvableKey<T> resolvableKey, T instance) {
        T value = instance;
        for (InstancePostProcessor instancePostProcessor : this.instancePostProcessors) {
            value = instancePostProcessor.postProcessBeforeInitialization(resolvableKey, value);
        }
        return value;
    }

    protected <T> T postProcessAfterInitialization(ResolvableKey<T> resolvableKey, T instance) {
        T value = instance;
        for (InstancePostProcessor instancePostProcessor : this.instancePostProcessors) {
            value = instancePostProcessor.postProcessAfterInitialization(resolvableKey, value);
        }
        return value;
    }

    protected <T> T invokeFactory(Executable factory, Object ... arguments) {
        if (factory instanceof Method) {
            return (T)Cast.cast((Object)this.agent.invokeMethod((Method)factory, null, arguments));
        }
        return this.agent.newInstance((Constructor)Cast.cast((Object)factory), arguments);
    }

    protected List<Supplier<?>> getArgumentFactories(Key<?> key, List<InjectionPoint<?>> argumentInjectionPoints, DependencyChain dependencyChain) {
        DependencyChain newChain = dependencyChain.withDependency(key);
        return argumentInjectionPoints.stream().map(injectionPoint -> this.getArgumentFactory((InjectionPoint)injectionPoint, newChain)).collect(Collectors.toList());
    }

    protected <T> Supplier<T> getArgumentFactory(InjectionPoint<T> injectionPoint, DependencyChain dependencyChain) {
        Key key = injectionPoint.getKey();
        if (key.getRawType() != Supplier.class && dependencyChain.hasDependency(key)) {
            throw new CircularDependencyException(key, dependencyChain);
        }
        AnnotatedElement element = injectionPoint.getElement();
        ResolvableKey resolvableKey = ResolvableKey.of(key, injectionPoint.getAliases(), dependencyChain);
        return () -> {
            this.currentInjectionPoint.set(injectionPoint);
            try {
                Object instance = this.getInstance(resolvableKey);
                this.validate(element, key.getName(), instance);
                Object t = instance;
                return t;
            }
            finally {
                this.currentInjectionPoint.remove();
            }
        };
    }

    @Override
    public boolean hasBinding(Key<?> key) {
        return this.bindings.containsKey(key);
    }

    @Override
    public Scope getRegisteredScope(Class<? extends Annotation> scopeType) {
        return (Scope)this.scopes.get(scopeType);
    }

    @Override
    public void registerScope(Class<? extends Annotation> scopeType, Scope scope) {
        this.scopes.put(scopeType, scope);
    }

    protected Scope getScopeForType(Class<?> type) {
        Annotation scopeType = AnnotationUtil.getElementAnnotationHavingMetaAnnotation(type, ScopeType.class);
        Scope registeredScope = scopeType != null ? this.getRegisteredScope(scopeType.annotationType()) : null;
        return registeredScope != null ? registeredScope : DefaultScope.INSTANCE;
    }

    protected Scope getScopeForMethod(Method method) {
        Annotation methodScopeType = AnnotationUtil.getElementAnnotationHavingMetaAnnotation(method, ScopeType.class);
        Scope methodScope = methodScopeType != null ? this.getRegisteredScope(methodScopeType.annotationType()) : null;
        return methodScope != null ? methodScope : this.getScopeForType(method.getReturnType());
    }

    @Override
    public void registerBundle(Object bundle) {
        Object bundleInstance = bundle instanceof Class ? this.getInstance((Class)bundle) : bundle;
        Class<?> bundleClass = bundleInstance.getClass();
        Set conditionalClasses = AnnotationUtil.findLogicalAnnotations(bundleClass, Conditional.class).map(Conditional::value).collect(Collectors.toSet());
        List globalConditions = conditionalClasses.stream().map(this::getInstance).collect(Collectors.toList());
        ConditionContext context = ConditionContext.of(this);
        ArrayList<Method> factoryMethods = new ArrayList<Method>();
        for (Method method : AnnotationUtil.getDeclaredMethodsMetaAnnotatedWith(bundleClass, FactoryType.class)) {
            if (!bundleClass.equals(method.getDeclaringClass()) && !factoryMethods.stream().noneMatch(m -> method.getName().equals(m.getName()) && Arrays.equals(method.getParameterTypes(), m.getParameterTypes()))) continue;
            Stream<Condition> localConditions = AnnotationUtil.findLogicalAnnotations(method, Conditional.class).map(Conditional::value).filter(conditionalClass -> !conditionalClasses.contains(conditionalClass)).map(this::getInstance);
            Stream<Condition> applicableConditions = Stream.concat(globalConditions.stream(), localConditions);
            if (!applicableConditions.allMatch(condition -> condition.matches(context, method))) continue;
            LOGGER.debug("Registering binding for bundle ({}) method: {}", bundleClass, (Object)method);
            this.registerBundleMethod(bundleInstance, method);
            factoryMethods.add(method);
        }
    }

    protected <T> void registerBundleMethod(Object bundleInstance, Method method) {
        Key primaryKey = Key.forMethod(method);
        if (this.hasBinding(primaryKey)) {
            LOGGER.error("Binding already exists for {}", primaryKey);
            throw new DuplicateBindingException(primaryKey);
        }
        List<InjectionPoint<?>> injectionPoints = InjectionPoint.fromExecutable(method);
        List<Supplier<?>> argumentFactories = this.getArgumentFactories(primaryKey, injectionPoints, DependencyChain.empty());
        ResolvableKey resolvableKey = ResolvableKey.of(primaryKey);
        Supplier<Object> unscoped = () -> {
            Object[] arguments = argumentFactories.stream().map(Supplier::get).toArray();
            Object instance = Cast.cast((Object)this.agent.invokeMethod(method, bundleInstance, arguments));
            instance = this.postProcessBeforeInitialization(resolvableKey, instance);
            this.injectMembers(primaryKey, instance, DependencyChain.empty());
            return this.postProcessAfterInitialization(resolvableKey, instance);
        };
        Supplier<Object> scoped = this.getScopeForMethod(method).get(primaryKey, unscoped);
        this.registerBinding(Binding.from(primaryKey).to(scoped));
        for (String alias : Keys.getAliases(method)) {
            Key aliasKey = primaryKey.withName(alias);
            if (this.hasBinding(aliasKey)) continue;
            this.registerBinding(Binding.from(aliasKey).to(scoped));
        }
    }

    @Override
    public void registerBinding(Binding<?> binding) {
        this.bindings.put(binding);
    }

    @Override
    public void registerBindingIfAbsent(Binding<?> binding) {
        this.bindings.putIfAbsent(binding);
    }

    @Override
    public void removeBinding(Key<?> key) {
        this.bindings.remove(key);
    }

    @Override
    public void registerFactoryResolver(FactoryResolver<?> resolver) {
        this.factoryResolvers.add(resolver);
    }

    @Override
    public void registerInstancePostProcessor(InstancePostProcessor instancePostProcessor) {
        this.instancePostProcessors.add(instancePostProcessor);
    }

    @Override
    public ConfigurableInstanceFactory newChildInstanceFactory() {
        return new DefaultInstanceFactory(this);
    }

    @Override
    public void setReflectionAgent(ReflectionAgent accessor) {
        this.agent = accessor;
    }

    @Override
    public void injectMembers(Object instance) {
        this.injectMembers(Key.forClass(instance.getClass()), instance, DependencyChain.empty());
    }

    protected void injectMembers(Key<?> key, Object instance, DependencyChain dependencyChain) {
        Class<?> rawType = instance.getClass();
        for (Field field : BeanUtils.getInjectableFields(rawType)) {
            this.injectField(field, instance);
        }
        ArrayList<Method> injectMethodsWithNoArgs = new ArrayList<Method>();
        DependencyChain updatedChain = dependencyChain.withDependency(key);
        for (Method method2 : BeanUtils.getInjectableMethods(rawType)) {
            if (method2.getParameterCount() == 0) {
                injectMethodsWithNoArgs.add(method2);
                continue;
            }
            List<InjectionPoint<?>> injectionPoints = InjectionPoint.fromExecutable(method2);
            Object[] args = injectionPoints.stream().map(point -> this.getArgumentFactory((InjectionPoint)point, updatedChain)).map(Supplier::get).toArray();
            this.agent.invokeMethod(method2, instance, args);
        }
        injectMethodsWithNoArgs.forEach(method -> this.agent.invokeMethod((Method)method, instance, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void injectField(Field field, Object instance) {
        InjectionPoint point = InjectionPoint.forField(field);
        this.currentInjectionPoint.set(point);
        ResolvableKey resolvableKey = ResolvableKey.of(point.getKey(), point.getAliases());
        try {
            Object value = this.getInstance(resolvableKey);
            if (value != null) {
                this.agent.setFieldValue(field, instance, value);
            }
            this.validate(field, resolvableKey.getName(), this.agent.getFieldValue(field, instance));
        }
        finally {
            this.currentInjectionPoint.remove();
        }
    }

    static enum DefaultScope implements Scope
    {
        INSTANCE;


        @Override
        public <T> Supplier<T> get(Key<T> key, Supplier<T> unscoped) {
            return unscoped;
        }

        public String toString() {
            return "[Unscoped]";
        }
    }
}

