/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jmx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.logging.log4j.core.helpers.Assert;
import org.apache.logging.log4j.core.jmx.LoggerContextAdminMBean;
import org.apache.logging.log4j.core.jmx.StatusLoggerAdminMBean;
import org.apache.logging.log4j.jmx.gui.Client;
import org.apache.logging.log4j.jmx.gui.ClientEditConfigPanel;

public class ClientGUI
extends JPanel
implements NotificationListener {
    private static final long serialVersionUID = -253621277232291174L;
    private final Client client;
    private JTextArea statusLogTextArea;
    private JTabbedPane tabbedPane;
    private JToggleButton wrapLinesToggleButton;
    private final AbstractAction toggleWrapAction = new AbstractAction(){
        private static final long serialVersionUID = -4214143754637722322L;

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean wrap = ClientGUI.this.wrapLinesToggleButton.isSelected();
            ClientGUI.this.statusLogTextArea.setLineWrap(wrap);
        }
    };

    public ClientGUI(Client client) throws InstanceNotFoundException, MalformedObjectNameException, IOException {
        this.client = (Client)Assert.isNotNull((Object)client, (String)"client");
        this.createWidgets();
        this.populateWidgets();
        this.registerListeners();
    }

    private void createWidgets() {
        this.statusLogTextArea = new JTextArea();
        this.statusLogTextArea.setEditable(false);
        this.statusLogTextArea.setBackground(this.getBackground());
        this.statusLogTextArea.setForeground(Color.black);
        this.statusLogTextArea.setFont(new Font("Monospaced", 0, this.statusLogTextArea.getFont().getSize()));
        this.statusLogTextArea.setWrapStyleWord(true);
        this.wrapLinesToggleButton = new JToggleButton(this.toggleWrapAction);
        this.wrapLinesToggleButton.setToolTipText("Toggle line wrapping");
        JScrollPane scrollStatusLog = new JScrollPane(this.statusLogTextArea, 22, 32);
        scrollStatusLog.setCorner("LOWER_RIGHT_CORNER", this.wrapLinesToggleButton);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("StatusLogger", scrollStatusLog);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
    }

    private void populateWidgets() {
        String[] messages;
        StatusLoggerAdminMBean statusAdmin = this.client.getStatusLoggerAdmin();
        for (String message : messages = statusAdmin.getStatusDataHistory()) {
            this.statusLogTextArea.append(message + "\n");
        }
        for (LoggerContextAdminMBean ctx : this.client.getLoggerContextAdmins()) {
            ClientEditConfigPanel editor = new ClientEditConfigPanel(ctx);
            this.tabbedPane.addTab("LoggerContext: " + ctx.getName(), editor);
        }
    }

    private void registerListeners() throws InstanceNotFoundException, MalformedObjectNameException, IOException {
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("com.apache.logging.log4j.core.jmx.statuslogger.message");
        ObjectName objName = new ObjectName("org.apache.logging.log4j2:type=StatusLogger");
        this.client.getConnection().addNotificationListener(objName, this, (NotificationFilter)filter, null);
    }

    @Override
    public void handleNotification(Notification notif, Object paramObject) {
        if ("com.apache.logging.log4j.core.jmx.statuslogger.message".equals(notif.getType())) {
            this.statusLogTextArea.append(notif.getMessage() + "\n");
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            ClientGUI.usage();
            return;
        }
        String serviceUrl = args[0];
        if (!serviceUrl.startsWith("service:jmx")) {
            serviceUrl = "service:jmx:rmi:///jndi/rmi://" + args[0] + "/jmxrmi";
        }
        JMXServiceURL url = new JMXServiceURL(serviceUrl);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (Object objKey : System.getProperties().keySet()) {
            String key = (String)objKey;
            paramMap.put(key, System.getProperties().getProperty(key));
        }
        JMXConnector connector = JMXConnectorFactory.connect(url, paramMap);
        final Client client = new Client(connector);
        final String title = "Log4j JMX Client - " + url;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClientGUI.installLookAndFeel();
                try {
                    ClientGUI gui = new ClientGUI(client);
                    JFrame frame = new JFrame(title);
                    frame.setDefaultCloseOperation(3);
                    frame.getContentPane().add((Component)gui, "Center");
                    frame.pack();
                    frame.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    StringWriter sr = new StringWriter();
                    ex.printStackTrace(new PrintWriter(sr));
                    JOptionPane.showMessageDialog(null, sr.toString(), "Error", 0);
                }
            }
        });
    }

    private static void usage() {
        String me = ClientGUI.class.getName();
        System.err.println("Usage: java " + me + " <host>:<port>");
        System.err.println("   or: java " + me + " service:jmx:rmi:///jndi/rmi://<host>:<port>/jmxrmi");
        String longAdr = " service:jmx:rmi://<host>:<port>/jndi/rmi://<host>:<port>/jmxrmi";
        System.err.println("   or: java " + me + " service:jmx:rmi://<host>:<port>/jndi/rmi://<host>:<port>/jmxrmi");
    }

    private static void installLookAndFeel() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

