/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jdbc.appender;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.logging.log4j.core.test.junit.LoggerContextRule;
import org.apache.logging.log4j.jdbc.appender.DataSourceConnectionSource;
import org.apache.logging.log4j.jndi.test.junit.JndiRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class DataSourceConnectionSourceTest {
    private static final String CONFIG = "log4j-fatalOnly.xml";
    @Rule
    public final RuleChain rules;
    private final DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
    private final String jndiURL;

    @Parameterized.Parameters(name="{0}")
    public static Object[][] data() {
        System.setProperty("log4j2.*.JNDI.enableJDBC", "true");
        return new Object[][]{{"java:/comp/env/jdbc/Logging01"}, {"java:/comp/env/jdbc/Logging02"}};
    }

    public DataSourceConnectionSourceTest(String jndiURL) {
        this.rules = RuleChain.outerRule((TestRule)new JndiRule(jndiURL, (Object)this.dataSource)).around((TestRule)new LoggerContextRule(CONFIG));
        this.jndiURL = jndiURL;
    }

    @Test
    public void testNullJndiName() {
        DataSourceConnectionSource source = DataSourceConnectionSource.createConnectionSource(null);
        Assert.assertNull((String)"The connection source should be null.", (Object)source);
    }

    @Test
    public void testEmptyJndiName() {
        DataSourceConnectionSource source = DataSourceConnectionSource.createConnectionSource((String)"");
        Assert.assertNull((String)"The connection source should be null.", (Object)source);
    }

    @Test
    public void testNoDataSource() {
        DataSourceConnectionSource source = DataSourceConnectionSource.createConnectionSource((String)(this.jndiURL + "123"));
        Assert.assertNull((String)"The connection source should be null.", (Object)source);
    }

    @Test
    public void testDataSource() throws SQLException {
        try (Connection connection1 = (Connection)Mockito.mock(Connection.class);
             Connection connection2 = (Connection)Mockito.mock(Connection.class);){
            BDDMockito.given((Object)this.dataSource.getConnection()).willReturn((Object)connection1, (Object[])new Connection[]{connection2});
            DataSourceConnectionSource source = DataSourceConnectionSource.createConnectionSource((String)this.jndiURL);
            Assert.assertNotNull((String)"The connection source should not be null.", (Object)source);
            Assert.assertEquals((String)"The toString value is not correct.", (Object)("dataSource{ name=" + this.jndiURL + ", value=" + this.dataSource + " }"), (Object)source.toString());
            Assert.assertSame((String)"The connection is not correct (1).", (Object)connection1, (Object)source.getConnection());
            Assert.assertSame((String)"The connection is not correct (2).", (Object)connection2, (Object)source.getConnection());
            source = DataSourceConnectionSource.createConnectionSource((String)this.jndiURL.substring(0, this.jndiURL.length() - 1));
            Assert.assertNull((String)"The connection source should be null now.", (Object)source);
        }
    }
}

