/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.api.dao;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.api.Attribute;
import org.apache.logging.log4j.catalog.api.CatalogReader;
import org.apache.logging.log4j.catalog.api.dao.AbstractCatalogReader;

public class JsonCatalogReader
extends AbstractCatalogReader {
    private static final Logger LOGGER = LogManager.getLogger(JsonCatalogReader.class);
    CatalogReader catalogReader;

    public CatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    public void setCatalogReader(CatalogReader catalogReader) {
        this.catalogReader = catalogReader;
    }

    public void init() {
        this.catalogData = this.catalogReader.read();
        for (Attribute attribute : this.catalogData.getAttributes()) {
            this.attributes.put(attribute.getName(), attribute);
        }
    }

    @Override
    public String readCatalog() {
        JsonFactory factory = new JsonFactory();
        factory.enable(JsonParser.Feature.ALLOW_COMMENTS);
        ObjectMapper mapper = new ObjectMapper(factory);
        try {
            return mapper.writeValueAsString((Object)this.catalogData);
        }
        catch (JsonProcessingException ex) {
            LOGGER.error("Unable to serialze Catalog", (Throwable)ex);
            return null;
        }
    }

    @Override
    public LocalDateTime getLastUpdated() {
        return this.catalogReader.getLastUpdated();
    }
}

