/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.internal.util;

import java.io.File;
import java.net.URL;

public class FileUtil {
    private static final String META_INF = "META-INF/";

    public FileLocation findLocation(Module module, ClassLoader classLoader, String fileName) {
        URL url2;
        if (module != null) {
            try {
                url2 = module.getClassLoader().getResource(META_INF + fileName);
                if (url2 != null) {
                    return FileLocation.MODULE;
                }
            }
            catch (Exception url2) {
                // empty catch block
            }
        }
        if (classLoader != null) {
            try {
                url2 = classLoader.getResource(META_INF + fileName);
                if (url2 != null) {
                    return FileLocation.CLASSLOADER;
                }
            }
            catch (Exception url3) {
                // empty catch block
            }
        }
        try {
            File file = new File(fileName);
            if (file.exists()) {
                return FileLocation.FILE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static enum FileLocation {
        MODULE,
        CLASSLOADER,
        URL,
        FILE;

    }
}

