/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Locale;
import org.apache.logging.log4j.junit.Mutable;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.util.Constants;
import org.junit.Assert;
import org.junit.Test;

public class FormattedMessageTest {
    private static final String SPACE = Constants.JAVA_MAJOR_VERSION < 9 ? " " : "\u00a0";
    private static final int LOOP_CNT = 500;
    String[] array = new String[500];

    @Test
    public void testStringNoArgs() {
        String testMsg = "Test message %1s";
        FormattedMessage msg = new FormattedMessage("Test message %1s", (Object[])null);
        String result = msg.getFormattedMessage();
        String expected = "Test message null";
        Assert.assertEquals((Object)"Test message null", (Object)result);
        Object[] array = null;
        msg = new FormattedMessage("Test message %1s", array, null);
        result = msg.getFormattedMessage();
        Assert.assertEquals((Object)"Test message null", (Object)result);
    }

    @Test
    public void tesStringOneStringArg() {
        String testMsg = "Test message %1s";
        FormattedMessage msg = new FormattedMessage("Test message %1s", (Object)"Apache");
        String result = msg.getFormattedMessage();
        String expected = "Test message Apache";
        Assert.assertEquals((Object)"Test message Apache", (Object)result);
    }

    @Test
    public void tesStringOneArgLocaleFrance_StringFormattedMessage() {
        String testMsg = "Test message e = %+10.4f";
        FormattedMessage msg = new FormattedMessage(Locale.FRANCE, "Test message e = %+10.4f", (Object)Math.E);
        String result = msg.getFormattedMessage();
        String expected = "Test message e =    +2,7183";
        Assert.assertEquals((Object)"Test message e =    +2,7183", (Object)result);
    }

    @Test
    public void tesStringOneArgLocaleFrance_MessageFormatMessage() {
        String testMsg = "Test message {0,number,currency}";
        FormattedMessage msg = new FormattedMessage(Locale.FRANCE, "Test message {0,number,currency}", (Object)12);
        String result = msg.getFormattedMessage();
        String expected = "Test message 12,00" + SPACE + "\u20ac";
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void tesStringOneArgLocaleUs_MessageFormatMessage() {
        String testMsg = "Test message {0,number,currency}";
        FormattedMessage msg = new FormattedMessage(Locale.US, "Test message {0,number,currency}", (Object)12);
        String result = msg.getFormattedMessage();
        String expected = "Test message $12.00";
        Assert.assertEquals((Object)"Test message $12.00", (Object)result);
    }

    @Test
    public void tesStringOneArgLocaleUs() {
        String testMsg = "Test message e = %+10.4f";
        FormattedMessage msg = new FormattedMessage(Locale.US, "Test message e = %+10.4f", (Object)Math.E);
        String result = msg.getFormattedMessage();
        String expected = "Test message e =    +2.7183";
        Assert.assertEquals((Object)"Test message e =    +2.7183", (Object)result);
    }

    @Test
    public void testNoArgs() {
        String testMsg = "Test message {0}";
        FormattedMessage msg = new FormattedMessage("Test message {0}", (Object[])null);
        String result = msg.getFormattedMessage();
        String expected = "Test message {0}";
        Assert.assertEquals((Object)"Test message {0}", (Object)result);
        Object[] array = null;
        msg = new FormattedMessage("Test message {0}", array, null);
        result = msg.getFormattedMessage();
        Assert.assertEquals((Object)"Test message {0}", (Object)result);
    }

    @Test
    public void testOneArg() {
        String testMsg = "Test message {0}";
        FormattedMessage msg = new FormattedMessage("Test message {0}", (Object)"Apache");
        String result = msg.getFormattedMessage();
        String expected = "Test message Apache";
        Assert.assertEquals((Object)"Test message Apache", (Object)result);
    }

    @Test
    public void testParamNoArgs() {
        String testMsg = "Test message {}";
        FormattedMessage msg = new FormattedMessage("Test message {}", null);
        String result = msg.getFormattedMessage();
        Assert.assertEquals((Object)"Test message {}", (Object)result);
        Object[] array = null;
        msg = new FormattedMessage("Test message {}", array, null);
        result = msg.getFormattedMessage();
        Assert.assertEquals((Object)"Test message {}", (Object)result);
    }

    @Test
    public void testUnsafeWithMutableParams() {
        String testMsg = "Test message %s";
        Mutable param = new Mutable().set("abc");
        FormattedMessage msg = new FormattedMessage("Test message %s", (Object)param);
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assert.assertEquals((String)"Expected most recent param value", (Object)"Test message XYZ", (Object)actual);
    }

    @Test
    public void testSafeAfterGetFormattedMessageIsCalled() {
        String testMsg = "Test message %s";
        Mutable param = new Mutable().set("abc");
        FormattedMessage msg = new FormattedMessage("Test message %s", (Object)param);
        msg.getFormattedMessage();
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assert.assertEquals((String)"Should use initial param value", (Object)"Test message abc", (Object)actual);
    }
}

