/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertiesUtilTest {
    private final Properties properties = new Properties();

    @Before
    public void setUp() throws Exception {
        this.properties.load(ClassLoader.getSystemResourceAsStream("PropertiesUtilTest.properties"));
    }

    @Test
    public void testExtractSubset() throws Exception {
        PropertiesUtilTest.assertHasAllProperties(PropertiesUtil.extractSubset((Properties)this.properties, (String)"a"));
        PropertiesUtilTest.assertHasAllProperties(PropertiesUtil.extractSubset((Properties)this.properties, (String)"b."));
        PropertiesUtilTest.assertHasAllProperties(PropertiesUtil.extractSubset((Properties)this.properties, (String)"c.1"));
        PropertiesUtilTest.assertHasAllProperties(PropertiesUtil.extractSubset((Properties)this.properties, (String)"dd"));
        Assert.assertEquals((long)0L, (long)this.properties.size());
    }

    @Test
    public void testPartitionOnCommonPrefix() throws Exception {
        Map parts = PropertiesUtil.partitionOnCommonPrefixes((Properties)this.properties);
        Assert.assertEquals((long)4L, (long)parts.size());
        PropertiesUtilTest.assertHasAllProperties((Properties)parts.get("a"));
        PropertiesUtilTest.assertHasAllProperties((Properties)parts.get("b"));
        PropertiesUtilTest.assertHasAllProperties((Properties)PropertiesUtil.partitionOnCommonPrefixes((Properties)((Properties)parts.get("c"))).get("1"));
        PropertiesUtilTest.assertHasAllProperties((Properties)parts.get("dd"));
    }

    private static void assertHasAllProperties(Properties properties) {
        Assert.assertNotNull((Object)properties);
        Assert.assertEquals((Object)"1", (Object)properties.getProperty("1"));
        Assert.assertEquals((Object)"2", (Object)properties.getProperty("2"));
        Assert.assertEquals((Object)"3", (Object)properties.getProperty("3"));
    }
}

