/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.osgi;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.logging.log4j.junit.BundleTestInfo;
import org.apache.logging.log4j.junit.OsgiRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.FrameworkFactory;

public abstract class AbstractLoadBundleTest {
    @Rule
    public OsgiRule osgi = new OsgiRule(this.getFactory());
    private final BundleTestInfo bundleTestInfo = new BundleTestInfo();

    protected abstract FrameworkFactory getFactory();

    @Before
    public void before() {
        String bundlePath = this.getBundlePath();
        Assume.assumeNotNull((Object[])new Object[]{bundlePath});
        File file = new File(bundlePath);
        Assume.assumeTrue((String)("File does not exist: " + file.getAbsolutePath() + ". Run 'mvn package -DskipTests' before 'mvn test'"), (boolean)file.exists());
    }

    protected String getBundlePath() {
        return "target/" + this.bundleTestInfo.getArtifactId() + '-' + this.bundleTestInfo.getVersion() + ".jar";
    }

    public String getExpectedBundleSymbolicName() {
        return "org.apache.logging." + this.bundleTestInfo.getArtifactId().replace('-', '.');
    }

    @Test
    public void testLoadStartStop() throws BundleException {
        BundleContext bundleContext = this.osgi.getFramework().getBundleContext();
        Bundle bundle = bundleContext.installBundle("file:" + this.getBundlePath());
        Assert.assertNotNull((String)"Error loading bundle: null returned", (Object)bundle);
        Assert.assertEquals((String)"Error loading bundle: symbolic name mismatch", (Object)this.getExpectedBundleSymbolicName(), (Object)bundle.getSymbolicName());
        Assert.assertEquals((String)"Bundle is not in INSTALLED state", (long)2L, (long)bundle.getState());
        bundle.start();
        Assert.assertEquals((String)"Bundle is not in ACTIVE state", (long)32L, (long)bundle.getState());
        bundle.stop();
        Assert.assertEquals((String)"Bundle is not in RESOLVED state", (long)4L, (long)bundle.getState());
        bundle.start();
        Assert.assertEquals((String)"Bundle is not in ACTIVE state", (long)32L, (long)bundle.getState());
        bundle.stop();
        Assert.assertEquals((String)"Bundle is not in RESOLVED state", (long)4L, (long)bundle.getState());
        bundle.uninstall();
        Assert.assertEquals((String)"Bundle is not in UNINSTALLED state", (long)1L, (long)bundle.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleLogInAnOsgiContext() throws BundleException, ReflectiveOperationException {
        BundleContext bundleContext = this.osgi.getFramework().getBundleContext();
        Bundle api = bundleContext.installBundle("file:" + this.getBundlePath());
        Bundle core = bundleContext.installBundle("file:../log4j-core/target/log4j-core-" + this.bundleTestInfo.getVersion() + ".jar");
        Bundle dummy = bundleContext.installBundle("file:../log4j-samples/configuration/target/log4j-samples-configuration-" + this.bundleTestInfo.getVersion() + ".jar");
        api.start();
        core.start();
        dummy.start();
        PrintStream bakStream = System.out;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream logStream = new PrintStream(baos);
            System.setOut(logStream);
            this.log(dummy);
            String result = baos.toString().substring(12).trim();
            Assert.assertEquals((Object)"[main] ERROR org.apache.logging.log4j.configuration.CustomConfiguration - Test OK", (Object)result);
        }
        finally {
            System.setOut(bakStream);
        }
        dummy.stop();
        core.stop();
        api.stop();
        dummy.uninstall();
        core.uninstall();
        api.uninstall();
    }

    @Test
    public void testMissingImportOfCoreOsgiPackage() throws BundleException, ReflectiveOperationException {
        BundleContext bundleContext = this.osgi.getFramework().getBundleContext();
        Bundle api = bundleContext.installBundle("file:" + this.getBundlePath());
        Bundle core = bundleContext.installBundle("file:../log4j-core/target/log4j-core-" + this.bundleTestInfo.getVersion() + ".jar");
        Bundle dummy = bundleContext.installBundle("file:../log4j-samples/configuration/target/log4j-samples-configuration-" + this.bundleTestInfo.getVersion() + ".jar");
        api.start();
        core.start();
        dummy.start();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream logStream = new PrintStream(baos);
        PrintStream bakStream = this.setupStream(api, logStream);
        this.log(dummy);
        this.setupStream(api, bakStream);
        boolean result = baos.toString().contains("ERROR StatusLogger Unable to create context org.apache.logging.log4j.core.osgi.BundleContextSelector");
        Assert.assertFalse((String)"org.apache.logging.log4j.core.osgi;resolution:=optional is missing in Import-Package in the POM", (boolean)result);
        dummy.stop();
        core.stop();
        api.stop();
        dummy.uninstall();
        core.uninstall();
        api.uninstall();
    }

    private void log(Bundle dummy) throws ReflectiveOperationException {
        Class logManagerClass = dummy.loadClass("org.apache.logging.log4j.LogManager");
        Method getLoggerMethod = logManagerClass.getMethod("getLogger", Class.class);
        Class loggerClass = dummy.loadClass("org.apache.logging.log4j.configuration.CustomConfiguration");
        Object logger = getLoggerMethod.invoke(null, loggerClass);
        Method infoMethod = logger.getClass().getMethod("error", Object.class);
        infoMethod.invoke(logger, "Test OK");
    }

    private PrintStream setupStream(Bundle api, PrintStream newStream) throws ReflectiveOperationException {
        Class statusLoggerClass = api.loadClass("org.apache.logging.log4j.status.StatusLogger");
        Field statusLoggerField = statusLoggerClass.getDeclaredField("STATUS_LOGGER");
        statusLoggerField.setAccessible(true);
        Object statusLoggerFieldValue = statusLoggerField.get(null);
        Field loggerField = statusLoggerClass.getDeclaredField("logger");
        loggerField.setAccessible(true);
        Object loggerFieldValue = loggerField.get(statusLoggerFieldValue);
        Class simpleLoggerClass = api.loadClass("org.apache.logging.log4j.simple.SimpleLogger");
        Field streamField = simpleLoggerClass.getDeclaredField("stream");
        streamField.setAccessible(true);
        PrintStream oldStream = (PrintStream)streamField.get(loggerFieldValue);
        streamField.set(loggerFieldValue, newStream);
        return oldStream;
    }
}

