/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.junit.ThreadContextRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CloseableThreadContextTest {
    private final String key = "key";
    private final String value = "value";
    @Rule
    public final ThreadContextRule threadContextRule = new ThreadContextRule();

    @Test
    public void shouldAddAnEntryToTheMap() throws Exception {
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value");){
            Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"value"));
        }
    }

    @Test
    public void shouldAddTwoEntriesToTheMap() throws Exception {
        String key2 = "key2";
        String value2 = "value2";
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value").put("key2", "value2");){
            Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"value"));
            Assert.assertThat((Object)ThreadContext.get((String)"key2"), (Matcher)CoreMatchers.is((Object)"value2"));
        }
    }

    @Test
    public void shouldNestEntries() throws Exception {
        String oldValue = "oldValue";
        String innerValue = "innerValue";
        ThreadContext.put((String)"key", (String)"oldValue");
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value");){
            Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"value"));
            try (CloseableThreadContext.Instance ignored2 = CloseableThreadContext.put((String)"key", (String)"innerValue");){
                Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"innerValue"));
            }
            Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"value"));
        }
        Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"oldValue"));
    }

    @Test
    public void shouldPreserveOldEntriesFromTheMapWhenAutoClosed() throws Exception {
        String oldValue = "oldValue";
        ThreadContext.put((String)"key", (String)"oldValue");
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value");){
            Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"value"));
        }
        Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"oldValue"));
    }

    @Test
    public void ifTheSameKeyIsAddedTwiceTheOriginalShouldBeUsed() throws Exception {
        String oldValue = "oldValue";
        String secondValue = "innerValue";
        ThreadContext.put((String)"key", (String)"oldValue");
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value").put("key", "innerValue");){
            Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"innerValue"));
        }
        Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"oldValue"));
    }

    @Test
    public void shouldPushAndPopAnEntryToTheStack() throws Exception {
        String message = "message";
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.push((String)"message");){
            Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)"message"));
        }
        Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void shouldPushAndPopTwoEntriesToTheStack() throws Exception {
        String message1 = "message1";
        String message2 = "message2";
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.push((String)"message1").push("message2");){
            Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)"message2"));
        }
        Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void shouldPushAndPopAParameterizedEntryToTheStack() throws Exception {
        String parameterizedMessage = "message {}";
        String parameterizedMessageParameter = "param";
        String formattedMessage = "message {}".replace("{}", "param");
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.push((String)"message {}", (Object[])new Object[]{"param"});){
            Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)formattedMessage));
        }
        Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void shouldRemoveAnEntryFromTheMapWhenAutoClosed() throws Exception {
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value");){
            Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"value"));
        }
        Assert.assertThat((Object)ThreadContext.containsKey((String)"key"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldAddEntriesToBothStackAndMap() throws Exception {
        String stackValue = "something";
        try (CloseableThreadContext.Instance ignored = CloseableThreadContext.put((String)"key", (String)"value").push("something");){
            Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"value"));
            Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)"something"));
        }
        Assert.assertThat((Object)ThreadContext.containsKey((String)"key"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void canReuseCloseableThreadContext() throws Exception {
        String stackValue = "something";
        CloseableThreadContext.Instance ctc = CloseableThreadContext.push((String)"something").put("key", "value");
        Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"value"));
        Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)"something"));
        ctc.close();
        Assert.assertThat((Object)ThreadContext.containsKey((String)"key"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)""));
        String anotherKey = "key2";
        String anotherValue = "value2";
        String anotherStackValue = "something else";
        ctc.push("something else").put("key2", "value2");
        Assert.assertThat((Object)ThreadContext.get((String)"key2"), (Matcher)CoreMatchers.is((Object)"value2"));
        Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)"something else"));
        ctc.close();
        Assert.assertThat((Object)ThreadContext.containsKey((String)"key2"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void closeIsIdempotent() throws Exception {
        String originalMapValue = "map to keep";
        String originalStackValue = "stack to keep";
        ThreadContext.put((String)"key", (String)"map to keep");
        ThreadContext.push((String)"stack to keep");
        String newMapValue = "temp map value";
        String newStackValue = "temp stack to keep";
        CloseableThreadContext.Instance ctc = CloseableThreadContext.push((String)"temp stack to keep").put("key", "temp map value");
        ctc.close();
        Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"map to keep"));
        Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)"stack to keep"));
        ctc.close();
        Assert.assertThat((Object)ThreadContext.get((String)"key"), (Matcher)CoreMatchers.is((Object)"map to keep"));
        Assert.assertThat((Object)ThreadContext.peek(), (Matcher)CoreMatchers.is((Object)"stack to keep"));
    }
}

