/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.spi.DefaultThreadContextMap;
import org.apache.logging.log4j.spi.DefaultThreadContextStack;
import org.apache.logging.log4j.spi.MutableThreadContextStack;
import org.apache.logging.log4j.spi.MutableThreadContextStackTest;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultThreadContextStackTest {
    @Before
    public void before() {
        new DefaultThreadContextMap(true).clear();
    }

    @Test
    public void testEqualsVsSameKind() {
        DefaultThreadContextStack stack1 = DefaultThreadContextStackTest.createStack();
        DefaultThreadContextStack stack2 = DefaultThreadContextStackTest.createStack();
        Assert.assertEquals((Object)stack1, (Object)stack1);
        Assert.assertEquals((Object)stack2, (Object)stack2);
        Assert.assertEquals((Object)stack1, (Object)stack2);
        Assert.assertEquals((Object)stack2, (Object)stack1);
    }

    @Test
    public void testEqualsVsMutable() {
        DefaultThreadContextStack stack1 = DefaultThreadContextStackTest.createStack();
        MutableThreadContextStack stack2 = MutableThreadContextStackTest.createStack();
        Assert.assertEquals((Object)stack1, (Object)stack1);
        Assert.assertEquals((Object)stack2, (Object)stack2);
        Assert.assertEquals((Object)stack1, (Object)stack2);
        Assert.assertEquals((Object)stack2, (Object)stack1);
    }

    @Test
    public void testHashCodeVsSameKind() {
        DefaultThreadContextStack stack1 = DefaultThreadContextStackTest.createStack();
        DefaultThreadContextStack stack2 = DefaultThreadContextStackTest.createStack();
        Assert.assertEquals((long)stack1.hashCode(), (long)stack2.hashCode());
    }

    @Test
    public void testImmutableOrNullReturnsNullIfUseStackIsFalse() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(false);
        stack.clear();
        Assert.assertEquals(null, (Object)stack.getImmutableStackOrNull());
    }

    @Test
    public void testImmutableOrNullReturnsNullIfStackIsEmpty() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(true);
        stack.clear();
        Assert.assertTrue((boolean)stack.isEmpty());
        Assert.assertEquals(null, (Object)stack.getImmutableStackOrNull());
    }

    @Test
    public void testImmutableOrNullReturnsCopyOfContents() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Assert.assertTrue((!stack.isEmpty() ? 1 : 0) != 0);
        ThreadContext.ContextStack actual = stack.getImmutableStackOrNull();
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)stack, (Object)actual);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testModifyingImmutableOrNullThrowsException() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        int originalSize = stack.size();
        Assert.assertTrue((originalSize > 0 ? 1 : 0) != 0);
        ThreadContext.ContextStack actual = stack.getImmutableStackOrNull();
        Assert.assertEquals((long)originalSize, (long)actual.size());
        actual.pop();
    }

    @Test
    public void testDoesNothingIfConstructedWithUseStackIsFalse() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(false);
        stack.clear();
        Assert.assertTrue((boolean)stack.isEmpty());
        stack.push("msg");
        Assert.assertTrue((boolean)stack.isEmpty());
        Assert.assertEquals((long)0L, (long)stack.size());
    }

    @Test
    public void testPushAndAddIncreaseStack() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(true);
        stack.clear();
        Assert.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        Assert.assertEquals((long)2L, (long)stack.size());
    }

    @Test
    public void testPeekReturnsLastAddedItem() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(true);
        stack.clear();
        Assert.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        Assert.assertEquals((long)2L, (long)stack.size());
        Assert.assertEquals((Object)"msg2", (Object)stack.peek());
        stack.push("msg3");
        Assert.assertEquals((Object)"msg3", (Object)stack.peek());
    }

    @Test
    public void testPopRemovesLastAddedItem() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Assert.assertEquals((long)3L, (long)stack.getDepth());
        Assert.assertEquals((Object)"msg3", (Object)stack.pop());
        Assert.assertEquals((long)2L, (long)stack.size());
        Assert.assertEquals((long)2L, (long)stack.getDepth());
        Assert.assertEquals((Object)"msg2", (Object)stack.pop());
        Assert.assertEquals((long)1L, (long)stack.size());
        Assert.assertEquals((long)1L, (long)stack.getDepth());
        Assert.assertEquals((Object)"msg1", (Object)stack.pop());
        Assert.assertEquals((long)0L, (long)stack.size());
        Assert.assertEquals((long)0L, (long)stack.getDepth());
    }

    @Test
    public void testAsList() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(true);
        stack.clear();
        Assert.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        stack.push("msg3");
        Assert.assertEquals(Arrays.asList("msg1", "msg2", "msg3"), (Object)stack.asList());
    }

    @Test
    public void testTrim() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        stack.trim(1);
        Assert.assertEquals((long)1L, (long)stack.size());
        Assert.assertEquals((Object)"msg1", (Object)stack.peek());
    }

    @Test
    public void testCopy() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        ThreadContextStack copy = stack.copy();
        Assert.assertEquals((long)3L, (long)copy.size());
        Assert.assertTrue((boolean)copy.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
        stack.clear();
        Assert.assertTrue((boolean)stack.isEmpty());
        Assert.assertEquals((long)3L, (long)copy.size());
        Assert.assertTrue((boolean)copy.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
        copy.add((Object)"other");
        Assert.assertEquals((long)4L, (long)copy.size());
        Assert.assertTrue((boolean)stack.isEmpty());
        stack.push("newStackMsg");
        Assert.assertEquals((long)1L, (long)stack.size());
        Assert.assertEquals((long)4L, (long)copy.size());
        copy.clear();
        Assert.assertTrue((boolean)copy.isEmpty());
        Assert.assertEquals((long)1L, (long)stack.size());
    }

    @Test
    public void testClear() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        stack.clear();
        Assert.assertTrue((boolean)stack.isEmpty());
    }

    static DefaultThreadContextStack createStack() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(true);
        stack.clear();
        Assert.assertTrue((boolean)stack.isEmpty());
        stack.push("msg1");
        stack.add("msg2");
        stack.push("msg3");
        Assert.assertEquals((long)3L, (long)stack.size());
        return stack;
    }

    @Test
    public void testContains() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Assert.assertTrue((boolean)stack.contains((Object)"msg1"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg2"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg3"));
    }

    @Test
    public void testIteratorReturnsInListOrderNotStackOrder() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Iterator iter = stack.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"msg1", iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"msg2", iter.next());
        Assert.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"msg3", iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testToArray() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Object[] expecteds = new String[]{"msg1", "msg2", "msg3"};
        Assert.assertArrayEquals((Object[])expecteds, (Object[])stack.toArray());
    }

    @Test
    public void testToArrayTArray() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Object[] expecteds = new String[]{"msg1", "msg2", "msg3"};
        Object[] result = new String[3];
        Assert.assertArrayEquals((Object[])expecteds, (Object[])stack.toArray(result));
        Assert.assertSame((Object)result, (Object)stack.toArray(result));
    }

    @Test
    public void testRemove() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Assert.assertTrue((boolean)stack.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
        stack.remove((Object)"msg1");
        Assert.assertEquals((long)2L, (long)stack.size());
        Assert.assertTrue((boolean)stack.containsAll(Arrays.asList("msg2", "msg3")));
        Assert.assertEquals((Object)"msg3", (Object)stack.peek());
        stack.remove((Object)"msg3");
        Assert.assertEquals((long)1L, (long)stack.size());
        Assert.assertTrue((boolean)stack.containsAll(Arrays.asList("msg2")));
        Assert.assertEquals((Object)"msg2", (Object)stack.peek());
    }

    @Test
    public void testContainsAll() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        Assert.assertTrue((boolean)stack.containsAll(Arrays.asList("msg1", "msg2", "msg3")));
    }

    @Test
    public void testAddAll() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        stack.addAll(Arrays.asList("msg4", "msg5"));
        Assert.assertEquals((long)5L, (long)stack.size());
        Assert.assertTrue((boolean)stack.contains((Object)"msg1"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg2"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg3"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg4"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg5"));
    }

    @Test
    public void testRemoveAll() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        stack.removeAll(Arrays.asList("msg1", "msg3"));
        Assert.assertEquals((long)1L, (long)stack.size());
        Assert.assertFalse((boolean)stack.contains((Object)"msg1"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg2"));
        Assert.assertFalse((boolean)stack.contains((Object)"msg3"));
    }

    @Test
    public void testRetainAll() {
        DefaultThreadContextStack stack = DefaultThreadContextStackTest.createStack();
        stack.retainAll(Arrays.asList("msg1", "msg3"));
        Assert.assertEquals((long)2L, (long)stack.size());
        Assert.assertTrue((boolean)stack.contains((Object)"msg1"));
        Assert.assertFalse((boolean)stack.contains((Object)"msg2"));
        Assert.assertTrue((boolean)stack.contains((Object)"msg3"));
    }

    @Test
    public void testToStringShowsListContents() {
        DefaultThreadContextStack stack = new DefaultThreadContextStack(true);
        stack.clear();
        Assert.assertEquals((Object)"[]", (Object)stack.toString());
        stack.push("msg1");
        stack.add("msg2");
        stack.push("msg3");
        Assert.assertEquals((Object)"[msg1, msg2, msg3]", (Object)stack.toString());
        stack.retainAll(Arrays.asList("msg1", "msg3"));
        Assert.assertEquals((Object)"[msg1, msg3]", (Object)stack.toString());
    }
}

