/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.osgi;

import java.io.File;
import org.apache.logging.log4j.osgi.BundleTestInfo;
import org.apache.logging.log4j.osgi.OsgiRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.FrameworkFactory;

public abstract class AbstractLoadBundleTest {
    @Rule
    public OsgiRule osgi = new OsgiRule(this.getFactory());
    private final BundleTestInfo bundleTestInfo = new BundleTestInfo();

    protected abstract FrameworkFactory getFactory();

    @Before
    public void before() {
        String bundlePath = this.getBundlePath();
        Assume.assumeNotNull((Object[])new Object[]{bundlePath});
        File file = new File(bundlePath);
        Assume.assumeTrue((String)("File does not exist: " + file.getAbsolutePath() + ". Run 'mvn package' before 'mvn test'"), (boolean)file.exists());
    }

    protected String getBundlePath() {
        return "target/" + this.bundleTestInfo.getArtifactId() + '-' + this.bundleTestInfo.getVersion() + ".jar";
    }

    public String getExpectedBundleSymbolicName() {
        return "org.apache.logging." + this.bundleTestInfo.getArtifactId();
    }

    @Test
    public void testLoadStartStop() throws BundleException {
        BundleContext bundleContext = this.osgi.getFramework().getBundleContext();
        Bundle bundle = bundleContext.installBundle("file:" + this.getBundlePath());
        Assert.assertNotNull((String)"Error loading bundle: null returned", (Object)bundle);
        Assert.assertEquals((String)"Error loading bundle: symbolic name mismatch", (Object)this.getExpectedBundleSymbolicName(), (Object)bundle.getSymbolicName());
        Assert.assertEquals((String)"Bundle is not in INSTALLED state", (long)2L, (long)bundle.getState());
        bundle.start();
        Assert.assertEquals((String)"Bundle is not in ACTIVE state", (long)32L, (long)bundle.getState());
        bundle.stop();
        Assert.assertEquals((String)"Bundle is not in RESOLVED state", (long)4L, (long)bundle.getState());
        bundle.start();
        Assert.assertEquals((String)"Bundle is not in ACTIVE state", (long)32L, (long)bundle.getState());
        bundle.stop();
        Assert.assertEquals((String)"Bundle is not in RESOLVED state", (long)4L, (long)bundle.getState());
    }
}

