/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.message.Mutable;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.junit.Assert;
import org.junit.Test;

public class ParameterizedMessageTest {
    @Test
    public void testNoArgs() {
        String testMsg = "Test message {}";
        ParameterizedMessage msg = new ParameterizedMessage("Test message {}", null);
        String result = msg.getFormattedMessage();
        Assert.assertEquals((Object)"Test message {}", (Object)result);
        Object[] array = null;
        msg = new ParameterizedMessage("Test message {}", array, null);
        result = msg.getFormattedMessage();
        Assert.assertEquals((Object)"Test message {}", (Object)result);
    }

    @Test
    public void testSafeWithMutableParams() {
        String testMsg = "Test message {}";
        Mutable param = new Mutable().set("abc");
        ParameterizedMessage msg = new ParameterizedMessage("Test message {}", (Object)param);
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assert.assertEquals((String)"Should use initial param value", (Object)"Test message abc", (Object)actual);
    }
}

