/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.message.MessageFormatMessage;
import org.apache.logging.log4j.message.Mutable;
import org.junit.Assert;
import org.junit.Test;

public class MessageFormatMessageTest {
    private static final int LOOP_CNT = 500;
    String[] array = new String[500];

    @Test
    public void testNoArgs() {
        String testMsg = "Test message {0}";
        MessageFormatMessage msg = new MessageFormatMessage("Test message {0}", (Object[])null);
        String result = msg.getFormattedMessage();
        String expected = "Test message {0}";
        Assert.assertEquals((Object)expected, (Object)result);
        Object array = null;
        msg = new MessageFormatMessage("Test message {0}", new Object[]{array, null});
        result = msg.getFormattedMessage();
        expected = "Test message null";
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testOneArg() {
        String testMsg = "Test message {0}";
        MessageFormatMessage msg = new MessageFormatMessage("Test message {0}", new Object[]{"Apache"});
        String result = msg.getFormattedMessage();
        String expected = "Test message Apache";
        Assert.assertEquals((Object)"Test message Apache", (Object)result);
    }

    @Test
    public void testException() {
        String testMsg = "Test message {0}";
        MessageFormatMessage msg = new MessageFormatMessage("Test message {0}", new Object[]{"Apache", new NullPointerException("Null")});
        String result = msg.getFormattedMessage();
        String expected = "Test message Apache";
        Assert.assertEquals((Object)"Test message Apache", (Object)result);
        Throwable t = msg.getThrowable();
        Assert.assertNotNull((String)"No Throwable", (Object)t);
    }

    @Test
    public void testUnsafeWithMutableParams() {
        String testMsg = "Test message {0}";
        Mutable param = new Mutable().set("abc");
        MessageFormatMessage msg = new MessageFormatMessage("Test message {0}", new Object[]{param});
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assert.assertEquals((String)"Expected most recent param value", (Object)"Test message XYZ", (Object)actual);
    }

    @Test
    public void testSafeAfterGetFormattedMessageIsCalled() {
        String testMsg = "Test message {0}";
        Mutable param = new Mutable().set("abc");
        MessageFormatMessage msg = new MessageFormatMessage("Test message {0}", new Object[]{param});
        msg.getFormattedMessage();
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assert.assertEquals((String)"Should use initial param value", (Object)"Test message abc", (Object)actual);
    }
}

