/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.message.MapMessage;
import org.junit.Assert;
import org.junit.Test;

public class MapMessageTest {
    @Test
    public void testMap() {
        String testMsg = "Test message {}";
        MapMessage msg = new MapMessage();
        msg.put("message", "Test message {}");
        msg.put("project", "Log4j");
        String result = msg.getFormattedMessage();
        String expected = "message=\"Test message {}\" project=\"Log4j\"";
        Assert.assertEquals((Object)"message=\"Test message {}\" project=\"Log4j\"", (Object)result);
    }

    @Test
    public void testXML() {
        String testMsg = "Test message {}";
        MapMessage msg = new MapMessage();
        msg.put("message", "Test message {}");
        msg.put("project", "Log4j");
        String result = msg.getFormattedMessage(new String[]{"XML"});
        String expected = "<Map>\n  <Entry key=\"message\">Test message {}</Entry>\n  <Entry key=\"project\">Log4j</Entry>\n</Map>";
        Assert.assertEquals((Object)"<Map>\n  <Entry key=\"message\">Test message {}</Entry>\n  <Entry key=\"project\">Log4j</Entry>\n</Map>", (Object)result);
    }

    @Test
    public void testJSON() {
        String testMsg = "Test message {}";
        MapMessage msg = new MapMessage();
        msg.put("message", "Test message {}");
        msg.put("project", "Log4j");
        String result = msg.getFormattedMessage(new String[]{"JSON"});
        String expected = "{\"message\":\"Test message {}\", \"project\":\"Log4j\"}";
        Assert.assertEquals((Object)"{\"message\":\"Test message {}\", \"project\":\"Log4j\"}", (Object)result);
    }

    @Test
    public void testJava() {
        String testMsg = "Test message {}";
        MapMessage msg = new MapMessage();
        msg.put("message", "Test message {}");
        msg.put("project", "Log4j");
        String result = msg.getFormattedMessage(new String[]{"Java"});
        String expected = "{message=\"Test message {}\", project=\"Log4j\"}";
        Assert.assertEquals((Object)"{message=\"Test message {}\", project=\"Log4j\"}", (Object)result);
    }

    @Test
    public void testMutableByDesign() {
        MapMessage msg = new MapMessage();
        msg.put("key1", "value1");
        msg.put("key2", "value2");
        String result = msg.getFormattedMessage(new String[]{"Java"});
        String expected = "{key1=\"value1\", key2=\"value2\"}";
        Assert.assertEquals((Object)"{key1=\"value1\", key2=\"value2\"}", (Object)result);
        msg.put("key3", "value3");
        String result2 = msg.getFormattedMessage(new String[]{"Java"});
        String expected2 = "{key1=\"value1\", key2=\"value2\", key3=\"value3\"}";
        Assert.assertEquals((Object)"{key1=\"value1\", key2=\"value2\", key3=\"value3\"}", (Object)result2);
    }
}

