/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import org.apache.logging.log4j.junit.Mutable;
import org.apache.logging.log4j.message.MessageFormatMessage;
import org.apache.logging.log4j.message.StringFormattedMessage;
import org.junit.Assert;
import org.junit.Test;

public class StringFormattedMessageTest {
    private static final int LOOP_CNT = 500;
    String[] array = new String[500];

    @Test
    public void testNoArgs() {
        String testMsg = "Test message %1s";
        StringFormattedMessage msg = new StringFormattedMessage("Test message %1s", (Object[])null);
        String result = msg.getFormattedMessage();
        String expected = "Test message null";
        Assert.assertEquals((Object)"Test message null", (Object)result);
        Object array = null;
        msg = new StringFormattedMessage("Test message %1s", new Object[]{array, null});
        result = msg.getFormattedMessage();
        Assert.assertEquals((Object)"Test message null", (Object)result);
    }

    @Test
    public void testOneStringArg() {
        String testMsg = "Test message %1s";
        StringFormattedMessage msg = new StringFormattedMessage("Test message %1s", new Object[]{"Apache"});
        String result = msg.getFormattedMessage();
        String expected = "Test message Apache";
        Assert.assertEquals((Object)"Test message Apache", (Object)result);
    }

    @Test
    public void testOneIntArgLocaleUs() {
        String testMsg = "Test e = %+10.4f";
        StringFormattedMessage msg = new StringFormattedMessage(Locale.US, "Test e = %+10.4f", new Object[]{Math.E});
        String result = msg.getFormattedMessage();
        String expected = "Test e =    +2.7183";
        Assert.assertEquals((Object)"Test e =    +2.7183", (Object)result);
    }

    @Test
    public void testOneArgLocaleFrance() {
        String testMsg = "Test e = %+10.4f";
        StringFormattedMessage msg = new StringFormattedMessage(Locale.FRANCE, "Test e = %+10.4f", new Object[]{Math.E});
        String result = msg.getFormattedMessage();
        String expected = "Test e =    +2,7183";
        Assert.assertEquals((Object)"Test e =    +2,7183", (Object)result);
    }

    @Test
    public void testException() {
        String testMsg = "Test message {0}";
        MessageFormatMessage msg = new MessageFormatMessage("Test message {0}", new Object[]{"Apache", new NullPointerException("Null")});
        String result = msg.getFormattedMessage();
        String expected = "Test message Apache";
        Assert.assertEquals((Object)"Test message Apache", (Object)result);
        Throwable t = msg.getThrowable();
        Assert.assertNotNull((String)"No Throwable", (Object)t);
    }

    @Test
    public void testUnsafeWithMutableParams() {
        String testMsg = "Test message %s";
        Mutable param = new Mutable().set("abc");
        StringFormattedMessage msg = new StringFormattedMessage("Test message %s", new Object[]{param});
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assert.assertEquals((String)"Should use initial param value", (Object)"Test message XYZ", (Object)actual);
    }

    @Test
    public void testSafeAfterGetFormattedMessageIsCalled() {
        String testMsg = "Test message %s";
        Mutable param = new Mutable().set("abc");
        StringFormattedMessage msg = new StringFormattedMessage("Test message %s", new Object[]{param});
        msg.getFormattedMessage();
        param.set("XYZ");
        String actual = msg.getFormattedMessage();
        Assert.assertEquals((String)"Should use initial param value", (Object)"Test message abc", (Object)actual);
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        StringFormattedMessage expected = new StringFormattedMessage("Msg", new Object[]{"a", "b", "c"});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(baos);){
            out.writeObject(expected);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        StringFormattedMessage actual = (StringFormattedMessage)in.readObject();
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected.getFormat(), (Object)actual.getFormat());
        Assert.assertEquals((Object)expected.getFormattedMessage(), (Object)actual.getFormattedMessage());
        Assert.assertArrayEquals((Object[])expected.getParameters(), (Object[])actual.getParameters());
    }
}

