/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.spi.DefaultThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextMapFactory;
import org.junit.Assert;
import org.junit.Test;

public class DefaultThreadContextMapTest {
    @Test
    public void testEqualsVsSameKind() {
        DefaultThreadContextMap map1 = this.createMap();
        DefaultThreadContextMap map2 = this.createMap();
        Assert.assertEquals((Object)map1, (Object)map1);
        Assert.assertEquals((Object)map2, (Object)map2);
        Assert.assertEquals((Object)map1, (Object)map2);
        Assert.assertEquals((Object)map2, (Object)map1);
    }

    @Test
    public void testHashCodeVsSameKind() {
        DefaultThreadContextMap map1 = this.createMap();
        DefaultThreadContextMap map2 = this.createMap();
        Assert.assertEquals((long)map1.hashCode(), (long)map2.hashCode());
    }

    @Test
    public void testDoesNothingIfConstructedWithUseMapIsFalse() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(false);
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertFalse((boolean)map.containsKey("key"));
        map.put("key", "value");
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertFalse((boolean)map.containsKey("key"));
        Assert.assertNull((Object)map.get("key"));
    }

    @Test
    public void testPut() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertFalse((boolean)map.containsKey("key"));
        map.put("key", "value");
        Assert.assertFalse((boolean)map.isEmpty());
        Assert.assertTrue((boolean)map.containsKey("key"));
        Assert.assertEquals((Object)"value", (Object)map.get("key"));
    }

    @Test
    public void testPutAll() {
        int i;
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertFalse((boolean)map.containsKey("key"));
        int mapSize = 10;
        HashMap<String, String> newMap = new HashMap<String, String>(10);
        for (i = 1; i <= 10; ++i) {
            newMap.put("key" + i, "value" + i);
        }
        map.putAll(newMap);
        Assert.assertFalse((boolean)map.isEmpty());
        for (i = 1; i <= 10; ++i) {
            Assert.assertTrue((boolean)map.containsKey("key" + i));
            Assert.assertEquals((Object)("value" + i), (Object)map.get("key" + i));
        }
    }

    @Test
    public void testRemove() {
        DefaultThreadContextMap map = this.createMap();
        Assert.assertEquals((Object)"value", (Object)map.get("key"));
        Assert.assertEquals((Object)"value2", (Object)map.get("key2"));
        map.remove("key");
        Assert.assertFalse((boolean)map.containsKey("key"));
        Assert.assertEquals((Object)"value2", (Object)map.get("key2"));
    }

    @Test
    public void testClear() {
        DefaultThreadContextMap map = this.createMap();
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertFalse((boolean)map.containsKey("key"));
        Assert.assertFalse((boolean)map.containsKey("key2"));
    }

    private DefaultThreadContextMap createMap() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        Assert.assertTrue((boolean)map.isEmpty());
        map.put("key", "value");
        map.put("key2", "value2");
        Assert.assertEquals((Object)"value", (Object)map.get("key"));
        Assert.assertEquals((Object)"value2", (Object)map.get("key2"));
        return map;
    }

    @Test
    public void testGetCopyReturnsMutableMap() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        Assert.assertTrue((boolean)map.isEmpty());
        Map copy = map.getCopy();
        Assert.assertTrue((boolean)copy.isEmpty());
        copy.put("key", "value");
        Assert.assertEquals((Object)"value", copy.get("key"));
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testGetCopyReturnsMutableCopy() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        map.put("key1", "value1");
        Assert.assertFalse((boolean)map.isEmpty());
        Map copy = map.getCopy();
        Assert.assertEquals((Object)"value1", copy.get("key1"));
        copy.put("key", "value");
        Assert.assertEquals((Object)"value", copy.get("key"));
        Assert.assertFalse((boolean)map.containsKey("key"));
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertFalse((boolean)copy.isEmpty());
    }

    @Test
    public void testGetImmutableMapReturnsNullIfEmpty() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertNull((Object)map.getImmutableMapOrNull());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetImmutableMapReturnsImmutableMapIfNonEmpty() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        map.put("key1", "value1");
        Assert.assertFalse((boolean)map.isEmpty());
        Map immutable = map.getImmutableMapOrNull();
        Assert.assertEquals((Object)"value1", immutable.get("key1"));
        immutable.put("key", "value");
    }

    @Test
    public void testGetImmutableMapCopyNotAffectdByContextMapChanges() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        map.put("key1", "value1");
        Assert.assertFalse((boolean)map.isEmpty());
        Map immutable = map.getImmutableMapOrNull();
        Assert.assertEquals((Object)"value1", immutable.get("key1"));
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertFalse((boolean)immutable.isEmpty());
    }

    @Test
    public void testToStringShowsMapContext() {
        DefaultThreadContextMap map = new DefaultThreadContextMap(true);
        Assert.assertEquals((Object)"{}", (Object)map.toString());
        map.put("key1", "value1");
        Assert.assertEquals((Object)"{key1=value1}", (Object)map.toString());
        map.remove("key1");
        map.put("key2", "value2");
        Assert.assertEquals((Object)"{key2=value2}", (Object)map.toString());
    }

    @Test
    public void testThreadLocalNotInheritableByDefault() {
        System.clearProperty("isThreadContextMapInheritable");
        ThreadLocal threadLocal = DefaultThreadContextMap.createThreadLocalMap((boolean)true);
        Assert.assertFalse((boolean)(threadLocal instanceof InheritableThreadLocal));
    }

    @Test
    public void testThreadLocalInheritableIfConfigured() {
        System.setProperty("isThreadContextMapInheritable", "true");
        ThreadContextMapFactory.init();
        try {
            ThreadLocal threadLocal = DefaultThreadContextMap.createThreadLocalMap((boolean)true);
            Assert.assertTrue((boolean)(threadLocal instanceof InheritableThreadLocal));
        }
        finally {
            System.clearProperty("isThreadContextMapInheritable");
        }
    }
}

