/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.TestLogger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.message.JsonMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.message.SimpleMessageFactory;
import org.apache.logging.log4j.message.StringFormatterMessageFactory;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.spi.MessageFactory2Adapter;
import org.apache.logging.log4j.util.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoggerTest {
    private final TestLogger logger = (TestLogger)LogManager.getLogger((String)"LoggerTest");
    private final Marker marker = MarkerManager.getMarker((String)"test");
    private final List<String> results = this.logger.getEntries();

    @Test
    public void basicFlow() {
        this.logger.entry();
        this.logger.exit();
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.equalTo((Object)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.equalTo((Object)"EXIT[ FLOW ] TRACE Exit"));
    }

    @Test
    public void flowTracingMessage() {
        this.logger.traceEntry(new JsonMessage(System.getProperties()));
        Response response = new Response(-1, "Generic error");
        this.logger.traceExit(new JsonMessage(response), response);
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"\"java.runtime.name\":"));
        Assert.assertThat((String)"incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        Assert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.containsString((String)"\"message\":\"Generic error\""));
    }

    @Test
    public void flowTracingString_ObjectArray1() {
        this.logger.traceEntry("doFoo(a={}, b={})", new Object[]{1, 2});
        this.logger.traceExit("doFoo(a=1, b=2): {}", 3);
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2)"));
        Assert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        Assert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2): 3"));
    }

    @Test
    public void flowTracingExitValueOnly() {
        this.logger.traceEntry("doFoo(a={}, b={})", new Object[]{1, 2});
        this.logger.traceExit(3);
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2)"));
        Assert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        Assert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.containsString((String)"3"));
    }

    @Test
    public void flowTracingString_ObjectArray2() {
        EntryMessage msg = this.logger.traceEntry("doFoo(a={}, b={})", new Object[]{1, 2});
        this.logger.traceExit(msg, 3);
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2)"));
        Assert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        Assert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2): 3"));
    }

    @Test
    public void flowTracingVoidReturn() {
        EntryMessage msg = this.logger.traceEntry("doFoo(a={}, b={})", new Object[]{1, 2});
        this.logger.traceExit(msg);
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2)"));
        Assert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        Assert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.endsWith((String)"doFoo(a=1, b=2)"));
    }

    @Test
    public void flowTracingNoExitArgs() {
        this.logger.traceEntry();
        this.logger.traceExit();
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
    }

    @Test
    public void flowTracingNoArgs() {
        EntryMessage message = this.logger.traceEntry();
        this.logger.traceExit(message);
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
    }

    @Test
    public void flowTracingString_SupplierOfObjectMessages() {
        EntryMessage msg = this.logger.traceEntry("doFoo(a={}, b={})", new Supplier[]{new Supplier<Message>(){

            public Message get() {
                return new ObjectMessage((Object)1);
            }
        }, new Supplier<Message>(){

            public Message get() {
                return new ObjectMessage((Object)2);
            }
        }});
        this.logger.traceExit(msg, 3);
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2)"));
        Assert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        Assert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2): 3"));
    }

    @Test
    public void flowTracingString_SupplierOfStrings() {
        EntryMessage msg = this.logger.traceEntry("doFoo(a={}, b={})", new Supplier[]{new Supplier<String>(){

            public String get() {
                return "1";
            }
        }, new Supplier<String>(){

            public String get() {
                return "2";
            }
        }});
        this.logger.traceExit(msg, 3);
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2)"));
        Assert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        Assert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2): 3"));
    }

    @Test
    public void catching() {
        try {
            throw new NullPointerException();
        }
        catch (Exception e) {
            this.logger.catching(e);
            Assert.assertEquals((long)1L, (long)this.results.size());
            Assert.assertThat((String)"Incorrect Catching", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"CATCHING[ EXCEPTION ] ERROR Catching java.lang.NullPointerException"));
            return;
        }
    }

    @Test
    public void debug() {
        this.logger.debug("Debug message");
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertTrue((String)"Incorrect message", (boolean)this.results.get(0).startsWith(" DEBUG Debug message"));
    }

    @Test
    public void debugObject() {
        this.logger.debug(new Date());
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertTrue((String)"Invalid length", (this.results.get(0).length() > 7 ? 1 : 0) != 0);
    }

    @Test
    public void debugWithParms() {
        this.logger.debug("Hello, {}", "World");
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertTrue((String)"Incorrect substitution", (boolean)this.results.get(0).startsWith(" DEBUG Hello, World"));
    }

    @Test
    public void debugWithParmsAndThrowable() {
        this.logger.debug("Hello, {}", "World", new RuntimeException("Test Exception"));
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertTrue((String)("Unexpected results: " + this.results.get(0)), (boolean)this.results.get(0).startsWith(" DEBUG Hello, World java.lang.RuntimeException: Test Exception"));
    }

    @Test
    public void getFormatterLogger() {
        TestLogger testLogger = (TestLogger)LogManager.getFormatterLogger();
        TestLogger altLogger = (TestLogger)LogManager.getFormatterLogger(this.getClass());
        Assert.assertEquals((Object)testLogger.getName(), (Object)altLogger.getName());
        Assert.assertNotNull((Object)((Object)testLogger));
        LoggerTest.assertMessageFactoryInstanceOf(testLogger.getMessageFactory(), StringFormatterMessageFactory.class);
        this.assertEqualMessageFactory((MessageFactory)StringFormatterMessageFactory.INSTANCE, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getFormatterLogger_Class() {
        TestLogger testLogger = (TestLogger)LogManager.getFormatterLogger(TestStringFormatterMessageFactory.class);
        Assert.assertNotNull((Object)((Object)testLogger));
        LoggerTest.assertMessageFactoryInstanceOf(testLogger.getMessageFactory(), StringFormatterMessageFactory.class);
        this.assertEqualMessageFactory((MessageFactory)StringFormatterMessageFactory.INSTANCE, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    private static void assertMessageFactoryInstanceOf(MessageFactory factory, Class<?> cls) {
        if (factory instanceof MessageFactory2Adapter) {
            factory = ((MessageFactory2Adapter)factory).getOriginal();
        }
        Assert.assertTrue((boolean)factory.getClass().isAssignableFrom(cls));
    }

    @Test
    public void getFormatterLogger_Object() {
        TestLogger testLogger = (TestLogger)LogManager.getFormatterLogger((Object)new TestStringFormatterMessageFactory());
        Assert.assertNotNull((Object)((Object)testLogger));
        LoggerTest.assertMessageFactoryInstanceOf(testLogger.getMessageFactory(), StringFormatterMessageFactory.class);
        this.assertEqualMessageFactory((MessageFactory)StringFormatterMessageFactory.INSTANCE, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getFormatterLogger_String() {
        StringFormatterMessageFactory messageFactory = StringFormatterMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getFormatterLogger((String)"getLogger_String_StringFormatterMessageFactory");
        Assert.assertNotNull((Object)((Object)testLogger));
        LoggerTest.assertMessageFactoryInstanceOf(testLogger.getMessageFactory(), StringFormatterMessageFactory.class);
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_Class_ParameterizedMessageFactory() {
        ParameterizedMessageFactory messageFactory = ParameterizedMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger(TestParameterizedMessageFactory.class, (MessageFactory)messageFactory);
        Assert.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("{}", Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)" DEBUG 2147483647", (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_Class_StringFormatterMessageFactory() {
        TestLogger testLogger = (TestLogger)LogManager.getLogger(TestStringFormatterMessageFactory.class, (MessageFactory)StringFormatterMessageFactory.INSTANCE);
        Assert.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)StringFormatterMessageFactory.INSTANCE, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_Object_ParameterizedMessageFactory() {
        ParameterizedMessageFactory messageFactory = ParameterizedMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((Object)new TestParameterizedMessageFactory(), (MessageFactory)messageFactory);
        Assert.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("{}", Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)" DEBUG 2147483647", (Object)testLogger.getEntries().get(0));
    }

    private void assertEqualMessageFactory(MessageFactory messageFactory, TestLogger testLogger) {
        MessageFactory actual = testLogger.getMessageFactory();
        if (actual instanceof MessageFactory2Adapter) {
            actual = ((MessageFactory2Adapter)actual).getOriginal();
        }
        Assert.assertEquals((Object)messageFactory, (Object)actual);
    }

    @Test
    public void getLogger_Object_StringFormatterMessageFactory() {
        StringFormatterMessageFactory messageFactory = StringFormatterMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((Object)new TestStringFormatterMessageFactory(), (MessageFactory)messageFactory);
        Assert.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_String_MessageFactoryMismatch() {
        StringFormatterMessageFactory messageFactory = StringFormatterMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((String)"getLogger_String_MessageFactoryMismatch", (MessageFactory)messageFactory);
        Assert.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        TestLogger testLogger2 = (TestLogger)LogManager.getLogger((String)"getLogger_String_MessageFactoryMismatch", (MessageFactory)ParameterizedMessageFactory.INSTANCE);
        Assert.assertNotNull((Object)((Object)testLogger2));
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_String_ParameterizedMessageFactory() {
        ParameterizedMessageFactory messageFactory = ParameterizedMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((String)"getLogger_String_ParameterizedMessageFactory", (MessageFactory)messageFactory);
        Assert.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("{}", Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)" DEBUG 2147483647", (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_String_SimpleMessageFactory() {
        SimpleMessageFactory messageFactory = SimpleMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((String)"getLogger_String_StringFormatterMessageFactory", (MessageFactory)messageFactory);
        Assert.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("{} %,d {foo}", Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)" DEBUG {} %,d {foo}", (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_String_StringFormatterMessageFactory() {
        StringFormatterMessageFactory messageFactory = StringFormatterMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((String)"getLogger_String_StringFormatterMessageFactory", (MessageFactory)messageFactory);
        Assert.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLoggerByClass() {
        Logger classLogger = LogManager.getLogger(LoggerTest.class);
        Assert.assertNotNull((Object)classLogger);
    }

    @Test
    public void getLoggerByNullClass() {
        Assert.assertNotNull((Object)LogManager.getLogger((Class)null));
    }

    @Test
    public void getLoggerByNullObject() {
        Assert.assertNotNull((Object)LogManager.getLogger(null));
    }

    @Test
    public void getLoggerByNullString() {
        Assert.assertNotNull((Object)LogManager.getLogger((String)null));
    }

    @Test
    public void getLoggerByObject() {
        Logger classLogger = LogManager.getLogger((Object)this);
        Assert.assertNotNull((Object)classLogger);
        Assert.assertEquals((Object)classLogger, (Object)LogManager.getLogger(LoggerTest.class));
    }

    @Test
    public void getRootLogger() {
        Assert.assertNotNull((Object)LogManager.getRootLogger());
        Assert.assertNotNull((Object)LogManager.getLogger((String)""));
        Assert.assertNotNull((Object)LogManager.getLogger((String)""));
        Assert.assertEquals((Object)LogManager.getRootLogger(), (Object)LogManager.getLogger((String)""));
        Assert.assertEquals((Object)LogManager.getRootLogger(), (Object)LogManager.getLogger((String)""));
    }

    @Test
    public void isAllEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.ALL));
    }

    @Test
    public void isDebugEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isDebugEnabled());
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.DEBUG));
    }

    @Test
    public void isErrorEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isErrorEnabled());
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.ERROR));
    }

    @Test
    public void isFatalEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isFatalEnabled());
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.FATAL));
    }

    @Test
    public void isInfoEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isInfoEnabled());
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.INFO));
    }

    @Test
    public void isOffEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.OFF));
    }

    @Test
    public void isTraceEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isTraceEnabled());
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.TRACE));
    }

    @Test
    public void isWarnEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isWarnEnabled());
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.WARN));
    }

    @Test
    public void isAllEnabledWithMarker() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.ALL, this.marker));
    }

    @Test
    public void isDebugEnabledWithMarker() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isDebugEnabled(this.marker));
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.DEBUG, this.marker));
    }

    @Test
    public void isErrorEnabledWithMarker() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isErrorEnabled(this.marker));
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.ERROR, this.marker));
    }

    @Test
    public void isFatalEnabledWithMarker() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isFatalEnabled(this.marker));
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.FATAL, this.marker));
    }

    @Test
    public void isInfoEnabledWithMarker() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isInfoEnabled(this.marker));
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.INFO, this.marker));
    }

    @Test
    public void isOffEnabledWithMarker() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.OFF, this.marker));
    }

    @Test
    public void isTraceEnabledWithMarker() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isTraceEnabled(this.marker));
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.TRACE, this.marker));
    }

    @Test
    public void isWarnEnabledWithMarker() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isWarnEnabled(this.marker));
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.WARN, this.marker));
    }

    @Test
    public void mdc() {
        ThreadContext.put((String)"TestYear", (String)Integer.valueOf(2010).toString());
        this.logger.debug("Debug message");
        String testYear = ThreadContext.get((String)"TestYear");
        Assert.assertNotNull((String)"Test Year is null", (Object)testYear);
        Assert.assertEquals((String)("Incorrect test year: " + testYear), (Object)"2010", (Object)testYear);
        ThreadContext.clearMap();
        this.logger.debug("Debug message");
        Assert.assertEquals((long)2L, (long)this.results.size());
        System.out.println("Log line 1: " + this.results.get(0));
        System.out.println("log line 2: " + this.results.get(1));
        Assert.assertTrue((String)("Incorrect MDC: " + this.results.get(0)), (boolean)this.results.get(0).startsWith(" DEBUG Debug message {TestYear=2010}"));
        Assert.assertTrue((String)("MDC not cleared?: " + this.results.get(1)), (boolean)this.results.get(1).startsWith(" DEBUG Debug message"));
    }

    @Test
    public void printf() {
        this.logger.printf(Level.DEBUG, "Debug message %d", new Object[]{1});
        this.logger.printf(Level.DEBUG, MarkerManager.getMarker((String)"Test"), "Debug message %d", new Object[]{2});
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect message", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)" DEBUG Debug message 1"));
        Assert.assertThat((String)"Incorrect message", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"Test DEBUG Debug message 2"));
    }

    @Before
    public void setup() {
        this.results.clear();
    }

    @Test
    public void structuredData() {
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName());
        StructuredDataMessage msg = new StructuredDataMessage("Audit@18060", "Transfer Complete", "Transfer");
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "123457");
        msg.put("Amount", "200.00");
        this.logger.info(MarkerManager.getMarker((String)"EVENT"), (Message)msg);
        ThreadContext.clearMap();
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect structured data: ", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"EVENT INFO Transfer [Audit@18060 Amount=\"200.00\" FromAccount=\"123457\" ToAccount=\"123456\"] Transfer Complete"));
    }

    @Test
    public void throwing() {
        this.logger.throwing(new IllegalArgumentException("Test Exception"));
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Throwing", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"THROWING[ EXCEPTION ] ERROR Throwing java.lang.IllegalArgumentException: Test Exception"));
    }

    private class Response {
        int status;
        String message;

        public Response(int status, String message) {
            this.status = status;
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    private static class TestStringFormatterMessageFactory {
        private TestStringFormatterMessageFactory() {
        }
    }

    private static class TestParameterizedMessageFactory {
        private TestParameterizedMessageFactory() {
        }
    }
}

