/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.io.Serializable;
import org.apache.commons.lang3.SerializationUtils;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;

public final class SerializableMatchers {
    public static <T extends Serializable> Matcher<T> serializesRoundTrip(Matcher<T> matcher) {
        return new FeatureMatcher<T, T>(matcher, "serializes round trip", "serializes round trip"){

            protected T featureValueOf(T actual) {
                return SerializationUtils.roundtrip(actual);
            }
        };
    }

    public static <T extends Serializable> Matcher<T> serializesRoundTrip(T expected) {
        return SerializableMatchers.serializesRoundTrip(IsEqual.equalTo(expected));
    }

    public static <T extends Serializable> Matcher<T> serializesRoundTrip(Class<T> clazz) {
        return SerializableMatchers.serializesRoundTrip(IsInstanceOf.any(clazz));
    }

    public static Matcher<? super Serializable> serializesRoundTrip() {
        return SerializableMatchers.serializesRoundTrip(IsInstanceOf.any(Serializable.class));
    }

    private SerializableMatchers() {
    }
}

