/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.TestLogger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.JsonMessage;
import org.apache.logging.log4j.message.LocalizedMessage;
import org.apache.logging.log4j.message.MessageFormatMessage;
import org.apache.logging.log4j.message.ObjectArrayMessage;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.StringFormattedMessage;
import org.apache.logging.log4j.message.ThreadDumpMessage;
import org.apache.logging.log4j.util.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoggerSupplierTest {
    private final TestLogger logger = (TestLogger)LogManager.getLogger((String)"LoggerTest");
    private final List<String> results = this.logger.getEntries();
    Locale defaultLocale;

    @Test
    public void flowTracing_SupplierOfFormattedMessage() {
        this.logger.traceEntry(new Supplier[]{new Supplier<FormattedMessage>(){

            public FormattedMessage get() {
                return new FormattedMessage("int foo={}", (Object)1234567890);
            }
        }});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"(int foo=1234567890)"));
        Assert.assertThat((String)"Bad toString()", (Object)this.results.get(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"FormattedMessage")));
    }

    @Test
    public void flowTracing_SupplierOfJsonMessage() {
        this.logger.traceEntry(new Supplier[]{new Supplier<JsonMessage>(){

            public JsonMessage get() {
                return new JsonMessage(System.getProperties());
            }
        }});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"\"java.runtime.name\":"));
        Assert.assertThat((String)"Bad toString()", (Object)this.results.get(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"JsonMessage")));
    }

    @Test
    public void flowTracing_SupplierOfLocalizedMessage() {
        this.logger.traceEntry(new Supplier[]{new Supplier<LocalizedMessage>(){

            public LocalizedMessage get() {
                return new LocalizedMessage("int foo={}", (Object)1234567890);
            }
        }});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"(int foo=1234567890)"));
        Assert.assertThat((String)"Bad toString()", (Object)this.results.get(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"LocalizedMessage")));
    }

    @Test
    public void flowTracing_SupplierOfLong() {
        this.logger.traceEntry(new Supplier[]{new Supplier<Long>(){

            public Long get() {
                return 1234567890L;
            }
        }});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"(1234567890)"));
        Assert.assertThat((String)"Bad toString()", (Object)this.results.get(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"SimpleMessage")));
    }

    @Test
    public void flowTracing_SupplierOfMessageFormatMessage() {
        this.logger.traceEntry(new Supplier[]{new Supplier<MessageFormatMessage>(){

            public MessageFormatMessage get() {
                return new MessageFormatMessage("int foo={0}", new Object[]{1234567890});
            }
        }});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"(int foo=1,234,567,890)"));
        Assert.assertThat((String)"Bad toString()", (Object)this.results.get(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"MessageFormatMessage")));
    }

    @Test
    public void flowTracing_SupplierOfObjectArrayMessage() {
        this.logger.traceEntry(new Supplier[]{new Supplier<ObjectArrayMessage>(){

            public ObjectArrayMessage get() {
                return new ObjectArrayMessage(new Object[]{1234567890});
            }
        }});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing Enter data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"([1234567890])"));
        Assert.assertThat((String)"Bad toString()", (Object)this.results.get(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"ObjectArrayMessage")));
    }

    @Test
    public void flowTracing_SupplierOfObjectMessage() {
        this.logger.traceEntry(new Supplier[]{new Supplier<ObjectMessage>(){

            public ObjectMessage get() {
                return new ObjectMessage((Object)1234567890);
            }
        }});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"(1234567890)"));
        Assert.assertThat((String)"Bad toString()", (Object)this.results.get(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"ObjectMessage")));
    }

    @Test
    public void flowTracing_SupplierOfParameterizedMessage() {
        this.logger.traceEntry(new Supplier[]{new Supplier<ParameterizedMessage>(){

            public ParameterizedMessage get() {
                return new ParameterizedMessage("int foo={}", (Object)1234567890);
            }
        }});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"(int foo=1234567890)"));
        Assert.assertThat((String)"Bad toString()", (Object)this.results.get(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"ParameterizedMessage")));
    }

    @Test
    public void flowTracing_SupplierOfSimpleMessage() {
        this.logger.traceEntry(new Supplier[]{new Supplier<SimpleMessage>(){

            public SimpleMessage get() {
                return new SimpleMessage("1234567890");
            }
        }});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"(1234567890)"));
        Assert.assertThat((String)"Bad toString()", (Object)this.results.get(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"SimpleMessage")));
    }

    @Test
    public void flowTracing_SupplierOfString() {
        this.logger.traceEntry(new Supplier[]{new Supplier<String>(){

            public String get() {
                return "1234567890";
            }
        }});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"(1234567890)"));
        Assert.assertThat((String)"Bad toString()", (Object)this.results.get(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"SimpleMessage")));
    }

    @Test
    public void flowTracing_SupplierOfStringFormattedMessage() {
        this.logger.traceEntry(new Supplier[]{new Supplier<StringFormattedMessage>(){

            public StringFormattedMessage get() {
                return new StringFormattedMessage("int foo=%,d", new Object[]{1234567890});
            }
        }});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"(int foo=1,234,567,890)"));
        Assert.assertThat((String)"Bad toString()", (Object)this.results.get(0), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"StringFormattedMessage")));
    }

    @Test
    public void flowTracing_SupplierOfThreadDumpMessage() {
        this.logger.traceEntry(new Supplier[]{new Supplier<ThreadDumpMessage>(){

            public ThreadDumpMessage get() {
                return new ThreadDumpMessage("Title of ...");
            }
        }});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"RUNNABLE"));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"Title of ..."));
        Assert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)this.getClass().getName()));
    }

    @Before
    public void setup() {
        this.results.clear();
        this.defaultLocale = Locale.getDefault(Locale.Category.FORMAT);
        Locale.setDefault(Locale.Category.FORMAT, Locale.US);
    }

    @After
    public void tearDown() {
        Locale.setDefault(Locale.Category.FORMAT, this.defaultLocale);
    }
}

